/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db.managed;

import com.google.common.primitives.UnsignedLong;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.ozone.util.ClosableIterator;

public class ManagedRawSSTFileIterator<T>
implements ClosableIterator<T> {
    private final long nativeHandle;
    private final Function<KeyValue, T> transformer;

    ManagedRawSSTFileIterator(long nativeHandle, Function<KeyValue, T> transformer) {
        this.nativeHandle = nativeHandle;
        this.transformer = transformer;
    }

    private native boolean hasNext(long var1);

    private native void next(long var1);

    private native byte[] getKey(long var1);

    private native byte[] getValue(long var1);

    private native long getSequenceNumber(long var1);

    private native int getType(long var1);

    public boolean hasNext() {
        return this.hasNext(this.nativeHandle);
    }

    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        KeyValue keyValue = new KeyValue(this.getKey(this.nativeHandle), UnsignedLong.fromLongBits((long)this.getSequenceNumber(this.nativeHandle)), this.getType(this.nativeHandle), this.getValue(this.nativeHandle));
        this.next(this.nativeHandle);
        return this.transformer.apply(keyValue);
    }

    private native void closeInternal(long var1);

    public void close() {
        this.closeInternal(this.nativeHandle);
    }

    public static final class KeyValue {
        private final byte[] key;
        private final UnsignedLong sequence;
        private final Integer type;
        private final byte[] value;

        private KeyValue(byte[] key, UnsignedLong sequence, Integer type, byte[] value) {
            this.key = key;
            this.sequence = sequence;
            this.type = type;
            this.value = value;
        }

        public byte[] getKey() {
            return Arrays.copyOf(this.key, this.key.length);
        }

        public UnsignedLong getSequence() {
            return this.sequence;
        }

        public Integer getType() {
            return this.type;
        }

        public byte[] getValue() {
            return Arrays.copyOf(this.value, this.value.length);
        }

        public String toString() {
            return "KeyValue{key=" + StringUtils.bytes2String((byte[])this.key) + ", sequence=" + this.sequence + ", type=" + this.type + ", value=" + StringUtils.bytes2String((byte[])this.value) + '}';
        }
    }
}

