/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.scm;

import java.io.IOException;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.ContainerOperationClient;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.ozone.admin.scm.ScmAdmin;
import picocli.CommandLine;

@CommandLine.Command(name="rotate", description={"CLI command to force generate new keys (rotate)"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class RotateKeySubCommand
extends ScmSubcommand {
    @CommandLine.Option(names={"--force"}, description={"Force generate new keys"})
    private boolean force = false;
    @CommandLine.ParentCommand
    private ScmAdmin parent;

    @Override
    protected void execute(ScmClient scmClient) throws IOException {
        ContainerOperationClient client = new ContainerOperationClient(this.parent.getParent().getOzoneConf());
        try {
            boolean status = false;
            try {
                status = client.rotateSecretKeys(this.force);
            }
            catch (IOException e) {
                System.err.println("Secret key rotation failed: " + e.getMessage());
                client.close();
                return;
            }
            if (status) {
                System.out.println("Secret key rotation is complete. A new key has been generated.");
            }
        }
        finally {
            try {
                client.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }
}

