/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.om;

import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.admin.om.OMAdmin;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.util.Time;
import picocli.CommandLine;

@CommandLine.Command(name="prepare", description={"Prepares Ozone Manager for upgrade/downgrade, by applying all pending transactions, taking a Ratis snapshot at the last transaction and purging all logs on each OM instance. The returned transaction #ID corresponds to the last transaction in the quorum in which the snapshot is taken."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class PrepareSubCommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private OMAdmin parent;
    @CommandLine.Option(names={"-id", "--service-id"}, description={"Ozone Manager Service ID"}, required=true)
    private String omServiceId;
    @CommandLine.Option(names={"-tawt", "--transaction-apply-wait-timeout"}, description={"Max time in SECONDS to wait for all transactions beforethe prepare request to be applied to the OM DB."}, defaultValue="120", hidden=true)
    private long txnApplyWaitTimeSeconds;
    @CommandLine.Option(names={"-tact", "--transaction-apply-check-interval"}, description={"Time in SECONDS to wait between successive checks for all transactions to be applied to the OM DB."}, defaultValue="5", hidden=true)
    private long txnApplyCheckIntervalSeconds;
    @CommandLine.Option(names={"-pct", "--prepare-check-interval"}, description={"Time in SECONDS to wait between successive checks for OM preparation."}, defaultValue="10", hidden=true)
    private long prepareCheckInterval;
    @CommandLine.Option(names={"-pt", "--prepare-timeout"}, description={"Max time in SECONDS to wait for all OMs to be prepared"}, defaultValue="300", hidden=true)
    private long prepareTimeOut;

    @Override
    public Void call() throws Exception {
        OzoneManagerProtocolClientSideTranslatorPB client = this.parent.createOmClient(this.omServiceId);
        long prepareTxnId = client.prepareOzoneManager(this.txnApplyWaitTimeSeconds, this.txnApplyCheckIntervalSeconds);
        System.out.println("Ozone Manager Prepare Request successfully returned with Transaction Id : [" + prepareTxnId + "].");
        HashMap omPreparedStatusMap = new HashMap();
        Set omHosts = OmUtils.getOmHostsFromConfig((OzoneConfiguration)this.parent.getParent().getOzoneConf(), (String)this.omServiceId);
        omHosts.forEach(h -> omPreparedStatusMap.put(h, false));
        Duration pTimeout = Duration.of(this.prepareTimeOut, ChronoUnit.SECONDS);
        Duration pInterval = Duration.of(this.prepareCheckInterval, ChronoUnit.SECONDS);
        System.out.println();
        System.out.println("Checking individual OM instances for prepare request completion...");
        long endTime = Time.monotonicNow() + pTimeout.toMillis();
        int expectedNumPreparedOms = omPreparedStatusMap.size();
        int currentNumPreparedOms = 0;
        while (Time.monotonicNow() < endTime && currentNumPreparedOms < expectedNumPreparedOms) {
            for (Map.Entry entry : omPreparedStatusMap.entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) continue;
                String omHost = (String)entry.getKey();
                try {
                    OzoneManagerProtocolClientSideTranslatorPB singleOmClient = this.parent.createOmClient(this.omServiceId, omHost, false);
                    try {
                        OzoneManagerProtocolProtos.PrepareStatusResponse response = singleOmClient.getOzoneManagerPrepareStatus(prepareTxnId);
                        OzoneManagerProtocolProtos.PrepareStatusResponse.PrepareStatus status = response.getStatus();
                        System.out.println("OM : [" + omHost + "], Prepare Status : [" + status.name() + "], Current Transaction Id : [" + response.getCurrentTxnIndex() + "]");
                        if (!status.equals((Object)OzoneManagerProtocolProtos.PrepareStatusResponse.PrepareStatus.PREPARE_COMPLETED)) continue;
                        entry.setValue(true);
                        ++currentNumPreparedOms;
                    }
                    finally {
                        if (singleOmClient == null) continue;
                        singleOmClient.close();
                    }
                }
                catch (IOException ioEx) {
                    System.out.println("Exception while checking preparation completeness for [" + omHost + "], Error : [" + ioEx.getMessage() + "]");
                }
            }
            if (currentNumPreparedOms >= expectedNumPreparedOms) continue;
            System.out.println("Waiting for " + this.prepareCheckInterval + " seconds before retrying...");
            Thread.sleep(pInterval.toMillis());
        }
        if (currentNumPreparedOms < (expectedNumPreparedOms + 1) / 2) {
            throw new Exception("OM Preparation failed since a majority OMs are not prepared yet.");
        }
        System.out.println();
        System.out.println("OM Preparation successful! ");
        if (currentNumPreparedOms == expectedNumPreparedOms) {
            System.out.println("All OMs are prepared");
        } else {
            System.out.println("A majority of OMs are prepared. OMs that are not prepared : " + omPreparedStatusMap.entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(e -> (String)e.getKey()).collect(Collectors.joining()));
        }
        System.out.println("No new write requests will be allowed until preparation is cancelled or upgrade/downgrade is done.");
        return null;
    }
}

