/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.pipeline;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.cli.pipeline.FilterPipelineOptions;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.server.JsonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List all active pipelines"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ListPipelinesSubcommand
extends ScmSubcommand {
    @CommandLine.Mixin
    private final FilterPipelineOptions filterOptions = new FilterPipelineOptions();
    @CommandLine.Option(names={"-s", "--state", "-fst", "--filterByState", "--filter-by-state"}, description={"Filter listed pipelines by State, eg OPEN, CLOSED"}, defaultValue="")
    private String state;
    @CommandLine.Option(names={"--json"}, defaultValue="false", description={"Format output as JSON"})
    private boolean json;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        Optional<Predicate<? super Pipeline>> replicationFilter = this.filterOptions.getReplicationFilter();
        Stream<Object> stream = scmClient.listPipelines().stream();
        if (replicationFilter.isPresent()) {
            stream = stream.filter(replicationFilter.get());
        }
        if (!Strings.isNullOrEmpty((String)this.state)) {
            stream = stream.filter(p -> p.getPipelineState().toString().compareToIgnoreCase(this.state) == 0);
        }
        if (this.json) {
            List pipelineList = stream.collect(Collectors.toList());
            System.out.print(JsonUtils.toJsonStringWithDefaultPrettyPrinter(pipelineList));
        } else {
            stream.forEach(System.out::println);
        }
    }
}

