/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.ScmOption;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.util.Time;
import picocli.CommandLine;

@CommandLine.Command(name="wait", description={"Wait until the scm is out from the safe mode."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class SafeModeWaitSubcommand
implements Callable<Void> {
    @CommandLine.Option(description={"Define timeout (in second) to wait until (exit code 1) or until safemode is ended (exit code 0)."}, defaultValue="30", names={"-t", "--timeout"})
    private long timeoutSeconds;
    private long startTestTime;
    @CommandLine.Mixin
    private ScmOption scmOption;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Void call() throws Exception {
        this.startTestTime = Time.monotonicNow();
        while (this.getRemainingTimeInSec() > 0L) {
            try {
                ScmClient scmClient = this.scmOption.createScmClient();
                try {
                    long remainingTime;
                    do {
                        if (!scmClient.inSafeMode()) {
                            System.out.println("SCM is out of safe mode.");
                            Void void_ = null;
                            return void_;
                        }
                        remainingTime = this.getRemainingTimeInSec();
                        if (remainingTime > 0L) {
                            System.out.printf("SCM is in safe mode. Will retry in 1 sec. Remaining time (sec): %s%n", remainingTime);
                            Thread.sleep(1000L);
                            continue;
                        }
                        System.out.println("SCM is in safe mode. No more retries.");
                    } while (remainingTime > 0L);
                }
                finally {
                    if (scmClient == null) continue;
                    scmClient.close();
                }
            }
            catch (InterruptedException ex) {
                System.out.printf("SCM is not available (yet?). Error is %s. Will retry in 1 sec. Remaining time (sec): %s%n", ex.getMessage(), this.getRemainingTimeInSec());
                Thread.sleep(1000L);
                Thread.currentThread().interrupt();
            }
        }
        throw new TimeoutException("Safe mode is not ended within the timeout period.");
    }

    private long getRemainingTimeInSec() {
        return this.timeoutSeconds - (Time.monotonicNow() - this.startTestTime) / 1000L;
    }
}

