/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.tasks.ReconEvent;

public class ReconTaskReInitializationEvent
implements ReconEvent {
    private final ReInitializationReason reason;
    private final long timestamp;
    private final ReconOMMetadataManager checkpointedOMMetadataManager;

    public ReconTaskReInitializationEvent(ReInitializationReason reason, ReconOMMetadataManager checkpointedOMMetadataManager) {
        this.reason = reason;
        this.timestamp = System.currentTimeMillis();
        this.checkpointedOMMetadataManager = checkpointedOMMetadataManager;
    }

    public ReInitializationReason getReason() {
        return this.reason;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ReconOMMetadataManager getCheckpointedOMMetadataManager() {
        return this.checkpointedOMMetadataManager;
    }

    @Override
    public ReconEvent.EventType getEventType() {
        return ReconEvent.EventType.TASK_REINITIALIZATION;
    }

    @Override
    public int getEventCount() {
        return 1;
    }

    public String toString() {
        return "ReconTaskReInitializationEvent{reason=" + (Object)((Object)this.reason) + ", timestamp=" + this.timestamp + '}';
    }

    public static enum ReInitializationReason {
        BUFFER_OVERFLOW,
        TASK_FAILURES,
        MANUAL_TRIGGER;

    }
}

