/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.ozone.recon.metrics.ReconTaskControllerMetrics;
import org.apache.hadoop.ozone.recon.tasks.ReconEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMUpdateEventBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(OMUpdateEventBuffer.class);
    private final BlockingQueue<ReconEvent> eventQueue;
    private final int maxCapacity;
    private final AtomicLong totalBufferedEvents = new AtomicLong(0L);
    private final AtomicLong droppedBatches = new AtomicLong(0L);
    private final ReconTaskControllerMetrics metrics;

    public OMUpdateEventBuffer(int maxCapacity, ReconTaskControllerMetrics metrics) {
        this.maxCapacity = maxCapacity;
        this.eventQueue = new LinkedBlockingQueue<ReconEvent>(maxCapacity);
        this.metrics = metrics;
    }

    public boolean offer(ReconEvent event) {
        boolean added = this.eventQueue.offer(event);
        if (added) {
            this.totalBufferedEvents.addAndGet(event.getEventCount());
            if (this.metrics != null) {
                this.metrics.incrEventBufferedCount(event.getEventCount());
                this.metrics.setEventCurrentQueueSize(this.eventQueue.size());
            }
            LOG.debug("Buffered event {} with {} events. Queue size: {}, Total buffered events: {}", new Object[]{event.getEventType(), event.getEventCount(), this.eventQueue.size(), this.totalBufferedEvents.get()});
        } else {
            this.droppedBatches.incrementAndGet();
            if (this.metrics != null) {
                this.metrics.incrEventDropCount(event.getEventCount());
            }
            LOG.warn("Event buffer queue is full (capacity: {}). Dropping event {} with {} events. Total dropped batches: {}", new Object[]{this.maxCapacity, event.getEventType(), event.getEventCount(), this.droppedBatches.get()});
        }
        return added;
    }

    public ReconEvent poll(long timeoutMs) {
        try {
            ReconEvent event = this.eventQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
            if (event != null) {
                this.totalBufferedEvents.addAndGet(-event.getEventCount());
                if (this.metrics != null) {
                    this.metrics.incrTotalEventCount(event.getEventCount());
                    this.metrics.setEventCurrentQueueSize(this.eventQueue.size());
                }
                LOG.debug("Polled event {} with {} events. Queue size: {}, Total buffered events: {}", new Object[]{event.getEventType(), event.getEventCount(), this.eventQueue.size(), this.totalBufferedEvents.get()});
            }
            return event;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public int getQueueSize() {
        return this.eventQueue.size();
    }

    public long getDroppedBatches() {
        return this.droppedBatches.get();
    }

    @VisibleForTesting
    public void clear() {
        this.eventQueue.clear();
        this.totalBufferedEvents.set(0L);
    }

    @VisibleForTesting
    public int drainTo(Collection<? super ReconEvent> drainedEvents) {
        int drained = this.eventQueue.drainTo(drainedEvents);
        if (drained > 0) {
            long totalEventCount = drainedEvents.stream().mapToLong(event -> ((ReconEvent)event).getEventCount()).sum();
            this.totalBufferedEvents.addAndGet(-totalEventCount);
            LOG.debug("Drained {} events from buffer. Remaining queue size: {}, Total buffered events: {}", new Object[]{drained, this.eventQueue.size(), this.totalBufferedEvents.get()});
        }
        return drained;
    }

    public void resetDroppedBatches() {
        this.droppedBatches.set(0L);
    }
}

