/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.util.Objects;

public final class OMDBUpdateEvent<KEY, VALUE> {
    private final OMDBUpdateAction action;
    private final String table;
    private final KEY updatedKey;
    private final VALUE updatedValue;
    private final VALUE oldValue;
    private final long sequenceNumber;

    private OMDBUpdateEvent(OMDBUpdateAction action, String table, KEY updatedKey, VALUE updatedValue, VALUE oldValue, long sequenceNumber) {
        this.action = action;
        this.table = table;
        this.updatedKey = updatedKey;
        this.updatedValue = updatedValue;
        this.oldValue = oldValue;
        this.sequenceNumber = sequenceNumber;
    }

    public OMDBUpdateAction getAction() {
        return this.action;
    }

    public String getTable() {
        return this.table;
    }

    public KEY getKey() {
        return this.updatedKey;
    }

    public VALUE getValue() {
        return this.updatedValue;
    }

    public VALUE getOldValue() {
        return this.oldValue;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OMDBUpdateEvent that = (OMDBUpdateEvent)o;
        return this.updatedKey.equals(that.updatedKey) && this.table.equals(that.table) && this.action.equals((Object)that.action);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.updatedKey, this.table, this.action});
    }

    public static enum OMDBUpdateAction {
        PUT,
        DELETE,
        UPDATE;

    }

    public static class OMUpdateEventBuilder<KEY, VALUE> {
        private OMDBUpdateAction action;
        private String table;
        private KEY updatedKey;
        private VALUE oldValue;
        private VALUE updatedValue;
        private long lastSequenceNumber;

        OMUpdateEventBuilder setAction(OMDBUpdateAction omdbUpdateAction) {
            this.action = omdbUpdateAction;
            return this;
        }

        OMUpdateEventBuilder setTable(String tableName) {
            this.table = tableName;
            return this;
        }

        OMUpdateEventBuilder setKey(KEY key) {
            this.updatedKey = key;
            return this;
        }

        OMUpdateEventBuilder setValue(VALUE value) {
            this.updatedValue = value;
            return this;
        }

        OMUpdateEventBuilder setOldValue(VALUE value) {
            this.oldValue = value;
            return this;
        }

        OMUpdateEventBuilder setSequenceNumber(long sequenceNumber) {
            this.lastSequenceNumber = sequenceNumber;
            return this;
        }

        public OMDBUpdateEvent build() {
            return new OMDBUpdateEvent(this.action, this.table, this.updatedKey, this.updatedValue, this.oldValue, this.lastSequenceNumber);
        }
    }
}

