/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.spi.impl;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.RDBBatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.recon.spi.ReconFileMetadataManager;
import org.apache.hadoop.ozone.recon.spi.impl.ReconDBDefinition;
import org.apache.hadoop.ozone.recon.spi.impl.ReconDBProvider;
import org.apache.hadoop.ozone.recon.tasks.FileSizeCountKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReconFileMetadataManagerImpl
implements ReconFileMetadataManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReconFileMetadataManagerImpl.class);
    private Table<FileSizeCountKey, Long> fileCountTable;
    private DBStore fileMetadataDbStore;

    @Inject
    public ReconFileMetadataManagerImpl(ReconDBProvider reconDBProvider) {
        this(reconDBProvider.getDbStore());
    }

    private ReconFileMetadataManagerImpl(DBStore reconDBStore) {
        this.fileMetadataDbStore = reconDBStore;
        this.initializeTables();
    }

    @Override
    public ReconFileMetadataManager getStagedReconFileMetadataManager(DBStore stagedReconDbStore) {
        return new ReconFileMetadataManagerImpl(stagedReconDbStore);
    }

    @Override
    public void reinitialize(ReconDBProvider reconDBProvider) {
        this.fileMetadataDbStore = reconDBProvider.getDbStore();
        this.initializeTables();
    }

    private void initializeTables() {
        try {
            this.fileCountTable = ReconDBDefinition.FILE_COUNT_BY_SIZE.getTable(this.fileMetadataDbStore);
        }
        catch (IOException e) {
            LOG.error("Unable to create File Size Count table.", (Throwable)e);
        }
    }

    @Override
    public void batchStoreFileSizeCount(BatchOperation batch, FileSizeCountKey fileSizeCountKey, Long count) throws IOException {
        this.fileCountTable.putWithBatch(batch, (Object)fileSizeCountKey, (Object)count);
    }

    @Override
    public void batchDeleteFileSizeCount(BatchOperation batch, FileSizeCountKey fileSizeCountKey) throws IOException {
        this.fileCountTable.deleteWithBatch(batch, (Object)fileSizeCountKey);
    }

    @Override
    public Long getFileSizeCount(FileSizeCountKey fileSizeCountKey) throws IOException {
        return (Long)this.fileCountTable.get((Object)fileSizeCountKey);
    }

    @Override
    public Table<FileSizeCountKey, Long> getFileCountTable() {
        return this.fileCountTable;
    }

    @Override
    public void commitBatchOperation(RDBBatchOperation rdbBatchOperation) throws IOException {
        this.fileMetadataDbStore.commitBatchOperation((BatchOperation)rdbBatchOperation);
    }

    @Override
    public void clearFileCountTable() throws IOException {
        ReconDBProvider.truncateTable(this.fileCountTable);
        LOG.info("Successfully cleared file count table");
    }
}

