/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.persistence;

import com.google.inject.Provider;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class TransactionalMethodInterceptor
implements MethodInterceptor {
    private Provider<DataSourceTransactionManager> transactionManagerProvider;

    TransactionalMethodInterceptor(Provider<DataSourceTransactionManager> transactionManagerProvider) {
        this.transactionManagerProvider = transactionManagerProvider;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        DataSourceTransactionManager transactionManager = (DataSourceTransactionManager)this.transactionManagerProvider.get();
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        TransactionStatus transaction = transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        try {
            Object result = invocation.proceed();
            try {
                if (transaction.isNewTransaction()) {
                    transactionManager.commit(transaction);
                }
            }
            catch (UnexpectedRollbackException unexpectedRollbackException) {
                // empty catch block
            }
            return result;
        }
        catch (Exception e) {
            if (transaction.isNewTransaction()) {
                transactionManager.rollback(transaction);
            }
            throw e;
        }
    }
}

