/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.types;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;

@XmlAccessorType(value=XmlAccessType.FIELD)
public final class PipelineMetadata {
    @XmlElement(name="pipelineId")
    private UUID pipelineId;
    @XmlElement(name="status")
    private Pipeline.PipelineState status;
    @XmlElement(name="leaderNode")
    private String leaderNode;
    @XmlElement(name="datanodes")
    private List<DatanodeDetails> datanodes;
    @XmlElement(name="lastLeaderElection")
    private long lastLeaderElection;
    @XmlElement(name="duration")
    private long duration;
    @XmlElement(name="leaderElections")
    private long leaderElections;
    @XmlElement(name="replicationType")
    private String replicationType;
    @XmlElement(name="replicationFactor")
    private String replicationFactor;
    @XmlElement(name="containers")
    private int containers;

    public UUID getPipelineId() {
        return this.pipelineId;
    }

    public Pipeline.PipelineState getStatus() {
        return this.status;
    }

    public String getLeaderNode() {
        return this.leaderNode;
    }

    public List<DatanodeDetails> getDatanodes() {
        return this.datanodes;
    }

    public long getLastLeaderElection() {
        return this.lastLeaderElection;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getLeaderElections() {
        return this.leaderElections;
    }

    public String getReplicationType() {
        return this.replicationType;
    }

    public String getReplicationFactor() {
        return this.replicationFactor;
    }

    public int getContainers() {
        return this.containers;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private PipelineMetadata(Builder b) {
        this.pipelineId = b.pipelineId;
        this.status = b.status;
        this.leaderNode = b.leaderNode;
        this.datanodes = b.datanodes;
        this.lastLeaderElection = b.lastLeaderElection;
        this.duration = b.duration;
        this.leaderElections = b.leaderElections;
        this.replicationType = b.replicationType;
        this.replicationFactor = b.replicationFactor;
        this.containers = b.containers;
    }

    public static class Builder {
        private UUID pipelineId;
        private Pipeline.PipelineState status;
        private String leaderNode = "";
        private List<DatanodeDetails> datanodes;
        private long lastLeaderElection = 0L;
        private long duration = 0L;
        private long leaderElections = 0L;
        private String replicationType;
        private String replicationFactor;
        private int containers = 0;

        public PipelineMetadata build() {
            Preconditions.checkNotNull((Object)this.pipelineId);
            Preconditions.checkNotNull((Object)this.status);
            Preconditions.checkNotNull(this.datanodes);
            Preconditions.checkNotNull((Object)this.replicationType);
            return new PipelineMetadata(this);
        }

        public Builder setPipelineId(UUID pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public Builder setStatus(Pipeline.PipelineState status) {
            this.status = status;
            return this;
        }

        public Builder setLeaderNode(String leaderNode) {
            this.leaderNode = leaderNode;
            return this;
        }

        public Builder setDatanodes(List<DatanodeDetails> datanodes) {
            this.datanodes = datanodes;
            return this;
        }

        public Builder setLastLeaderElection(long lastLeaderElection) {
            this.lastLeaderElection = lastLeaderElection;
            return this;
        }

        public Builder setDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder setLeaderElections(long leaderElections) {
            this.leaderElections = leaderElections;
            return this;
        }

        public Builder setReplicationConfig(ReplicationConfig replicationConfig) {
            this.replicationType = replicationConfig.getReplicationType().toString();
            this.replicationFactor = replicationConfig.getReplication();
            return this;
        }

        public Builder setContainers(int containers) {
            this.containers = containers;
            return this;
        }
    }
}

