/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.metadata.SCMDBDefinition;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.recon.api.AdminOnly;
import org.apache.hadoop.ozone.recon.api.types.ContainerBlocksInfoWrapper;
import org.apache.hadoop.ozone.recon.scm.ReconContainerManager;
import org.apache.hadoop.ozone.recon.scm.ReconStorageContainerManagerFacade;

@Path(value="/blocks")
@Produces(value={"application/json"})
@AdminOnly
public class BlocksEndPoint {
    private final DBStore scmDBStore;
    private final ReconContainerManager containerManager;

    @Inject
    public BlocksEndPoint(ReconStorageContainerManagerFacade reconSCM) {
        this.containerManager = (ReconContainerManager)reconSCM.getContainerManager();
        this.scmDBStore = reconSCM.getScmDBStore();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/deletePending")
    public Response getBlocksPendingDeletion(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="0") @QueryParam(value="prevKey") long prevKey) {
        if (limit < 0) return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        if (prevKey < 0L) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        HashMap containerStateBlockInfoListMap = new HashMap();
        try (Table.KeyValueIterator i = SCMDBDefinition.DELETED_BLOCKS.getTable(this.scmDBStore).iterator();){
            boolean skipPrevKey = false;
            if (prevKey > 0L) {
                skipPrevKey = true;
                Table.KeyValue seekKeyValue = (Table.KeyValue)i.seek((Object)prevKey);
                if (seekKeyValue == null) {
                    Response response = Response.ok(containerStateBlockInfoListMap).build();
                    return response;
                }
            }
            while (i.hasNext()) {
                List<ContainerBlocksInfoWrapper> containerBlocksInfoWrappers;
                Table.KeyValue kv = (Table.KeyValue)i.next();
                if (skipPrevKey && ((Long)kv.getKey()).equals(prevKey)) continue;
                StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction deletedBlocksTransaction = (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction)kv.getValue();
                long containerID = deletedBlocksTransaction.getContainerID();
                String containerState = this.containerManager.getContainer(ContainerID.valueOf((long)containerID)).getState().name();
                ContainerBlocksInfoWrapper containerBlocksInfoWrapper = new ContainerBlocksInfoWrapper();
                containerBlocksInfoWrapper.setContainerID(containerID);
                containerBlocksInfoWrapper.setLocalIDList(deletedBlocksTransaction.getLocalIDList());
                containerBlocksInfoWrapper.setLocalIDCount(deletedBlocksTransaction.getLocalIDCount());
                containerBlocksInfoWrapper.setTxID(deletedBlocksTransaction.getTxID());
                if (containerStateBlockInfoListMap.containsKey(containerState)) {
                    containerBlocksInfoWrappers = (List)containerStateBlockInfoListMap.get(containerState);
                } else {
                    containerBlocksInfoWrappers = new ArrayList();
                    containerStateBlockInfoListMap.put(containerState, containerBlocksInfoWrappers);
                }
                containerBlocksInfoWrappers.add(containerBlocksInfoWrapper);
                if (containerBlocksInfoWrappers.size() >= limit) return Response.ok(containerStateBlockInfoListMap).build();
            }
            return Response.ok(containerStateBlockInfoListMap).build();
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

