/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.recon.ReconConfig;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.VersionInfo;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.recon.ConfigurationProvider;
import org.apache.hadoop.ozone.recon.ReconContext;
import org.apache.hadoop.ozone.recon.ReconControllerModule;
import org.apache.hadoop.ozone.recon.ReconGuiceServletContextListener;
import org.apache.hadoop.ozone.recon.ReconHttpServer;
import org.apache.hadoop.ozone.recon.ReconRestServletModule;
import org.apache.hadoop.ozone.recon.ReconSchemaManager;
import org.apache.hadoop.ozone.recon.ReconSchemaVersionTableManager;
import org.apache.hadoop.ozone.recon.api.types.FeatureProvider;
import org.apache.hadoop.ozone.recon.metrics.ReconTaskStatusMetrics;
import org.apache.hadoop.ozone.recon.scm.ReconSafeModeManager;
import org.apache.hadoop.ozone.recon.scm.ReconStorageConfig;
import org.apache.hadoop.ozone.recon.security.ReconCertificateClient;
import org.apache.hadoop.ozone.recon.spi.OzoneManagerServiceProvider;
import org.apache.hadoop.ozone.recon.spi.ReconContainerMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.apache.hadoop.ozone.recon.spi.StorageContainerServiceProvider;
import org.apache.hadoop.ozone.recon.spi.impl.ReconDBProvider;
import org.apache.hadoop.ozone.recon.tasks.ReconTaskController;
import org.apache.hadoop.ozone.recon.upgrade.ReconLayoutVersionManager;
import org.apache.hadoop.ozone.util.OzoneNetUtils;
import org.apache.hadoop.ozone.util.OzoneVersionInfo;
import org.apache.hadoop.ozone.util.ShutdownHookManager;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.util.ExitUtil;
import org.apache.ozone.recon.schema.ReconSchemaGenerationModule;
import org.apache.ratis.util.JvmPauseMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconServer
extends GenericCli
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(ReconServer.class);
    private Injector injector;
    private JvmPauseMonitor jvmPauseMonitor;
    private ReconHttpServer httpServer;
    private ReconContainerMetadataManager reconContainerMetadataManager;
    private OzoneManagerServiceProvider ozoneManagerServiceProvider;
    private ReconDBProvider reconDBProvider;
    private ReconNamespaceSummaryManager reconNamespaceSummaryManager;
    private OzoneStorageContainerManager reconStorageContainerManager;
    private OzoneConfiguration configuration;
    private ReconStorageConfig reconStorage;
    private CertificateClient certClient;
    private ReconTaskStatusMetrics reconTaskStatusMetrics;
    private volatile boolean isStarted = false;

    public static void main(String[] args) {
        OzoneNetUtils.disableJvmNetworkAddressCacheIfRequired((OzoneConfiguration)new OzoneConfiguration());
        new ReconServer().run(args);
    }

    @Override
    public Void call() throws Exception {
        String[] originalArgs = this.getCmd().getParseResult().originalArgs().toArray(new String[0]);
        this.configuration = this.getOzoneConf();
        HddsServerUtil.startupShutdownMessage((VersionInfo)OzoneVersionInfo.OZONE_VERSION_INFO, ReconServer.class, (String[])originalArgs, (Logger)LOG, (OzoneConfiguration)this.configuration);
        ConfigurationProvider.setConfiguration(this.configuration);
        LOG.info("Initializing Recon server...");
        try {
            this.injector = Guice.createInjector((Module[])new Module[]{new ReconControllerModule(), new ReconRestServletModule((ConfigurationSource)this.configuration), new ReconSchemaGenerationModule()});
            ReconGuiceServletContextListener.setInjector(this.injector);
            this.reconStorage = (ReconStorageConfig)((Object)this.injector.getInstance(ReconStorageConfig.class));
            ReconServer.loginReconUserIfSecurityEnabled(this.configuration);
            try {
                if (this.reconStorage.getState() != Storage.StorageState.INITIALIZED) {
                    this.reconStorage.initialize();
                }
                if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)this.configuration)) {
                    LOG.info("ReconStorageConfig initialized.Initializing certificate.");
                    this.initializeCertificateClient();
                }
            }
            catch (Exception e) {
                LOG.error("Error during initializing Recon certificate", (Throwable)e);
            }
            this.jvmPauseMonitor = RatisHelper.newJvmPauseMonitor((String)"Recon");
            this.reconDBProvider = (ReconDBProvider)this.injector.getInstance(ReconDBProvider.class);
            this.reconContainerMetadataManager = (ReconContainerMetadataManager)this.injector.getInstance(ReconContainerMetadataManager.class);
            this.reconNamespaceSummaryManager = (ReconNamespaceSummaryManager)this.injector.getInstance(ReconNamespaceSummaryManager.class);
            ReconContext reconContext = (ReconContext)this.injector.getInstance(ReconContext.class);
            ReconSchemaManager reconSchemaManager = (ReconSchemaManager)this.injector.getInstance(ReconSchemaManager.class);
            LOG.info("Creating Recon Schema.");
            reconSchemaManager.createReconSchema();
            LOG.debug("Recon schema creation done.");
            ReconSafeModeManager reconSafeModeMgr = (ReconSafeModeManager)this.injector.getInstance(ReconSafeModeManager.class);
            reconSafeModeMgr.setInSafeMode(true);
            this.httpServer = (ReconHttpServer)((Object)this.injector.getInstance(ReconHttpServer.class));
            this.ozoneManagerServiceProvider = (OzoneManagerServiceProvider)this.injector.getInstance(OzoneManagerServiceProvider.class);
            this.reconStorageContainerManager = (OzoneStorageContainerManager)this.injector.getInstance(OzoneStorageContainerManager.class);
            this.reconTaskStatusMetrics = (ReconTaskStatusMetrics)this.injector.getInstance(ReconTaskStatusMetrics.class);
            LOG.info("Initializing support of Recon Features...");
            FeatureProvider.initFeatureSupport(this.configuration);
            LOG.debug("Now starting all services of Recon...");
            this.start();
            this.isStarted = true;
            LOG.info("Finalizing Layout Features.");
            ReconSchemaVersionTableManager versionTableManager = (ReconSchemaVersionTableManager)this.injector.getInstance(ReconSchemaVersionTableManager.class);
            DataSource dataSource = (DataSource)this.injector.getInstance(DataSource.class);
            ReconLayoutVersionManager layoutVersionManager = new ReconLayoutVersionManager(versionTableManager, reconContext, dataSource);
            layoutVersionManager.finalizeLayoutFeatures();
            LOG.info("Recon schema versioning completed.");
            LOG.info("Recon server initialized successfully!");
        }
        catch (Exception e) {
            LOG.error("Error during initializing Recon server.", (Throwable)e);
            this.updateAndLogReconHealthStatus();
        }
        ShutdownHookManager.get().addShutdownHook(() -> {
            try {
                this.stop();
                this.join();
            }
            catch (Exception e) {
                LOG.error("Error during stop Recon server", (Throwable)e);
            }
        }, 10);
        return null;
    }

    private void updateAndLogReconHealthStatus() {
        ReconContext reconContext = (ReconContext)this.injector.getInstance(ReconContext.class);
        assert (reconContext != null);
        this.checkComponentAndLog(this.getReconStorageContainerManager(), "ReconStorageContainerManagerFacade is not initialized properly.", reconContext);
        this.checkComponentAndLog(this.getReconNamespaceSummaryManager(), "ReconNamespaceSummaryManager is not initialized properly.", reconContext);
        this.checkComponentAndLog(this.getOzoneManagerServiceProvider(), "OzoneManagerServiceProvider is not initialized properly.", reconContext);
        this.checkComponentAndLog(this.getReconContainerMetadataManager(), "ReconContainerMetadataManager is not initialized properly.", reconContext);
    }

    private void checkComponentAndLog(Object component, String errorMessage, ReconContext context) {
        if (component == null) {
            LOG.error("{} Setting health status to false and adding error code.", (Object)errorMessage);
            context.updateHealthStatus(new AtomicBoolean(false));
            context.getErrors().add(ReconContext.ErrorCode.INTERNAL_ERROR);
        }
    }

    private void initializeCertificateClient() throws IOException {
        LOG.info("Initializing secure Recon.");
        SCMSecurityProtocolClientSideTranslatorPB scmSecurityClient = HddsServerUtil.getScmSecurityClientWithMaxRetry((OzoneConfiguration)this.configuration, (UserGroupInformation)UserGroupInformation.getCurrentUser());
        SecurityConfig secConf = new SecurityConfig((ConfigurationSource)this.configuration);
        this.certClient = new ReconCertificateClient(secConf, scmSecurityClient, this.reconStorage, this::saveNewCertId, this::terminateRecon);
        this.certClient.initWithRecovery();
    }

    public void saveNewCertId(String newCertId) {
        try {
            this.reconStorage.setReconCertSerialId(newCertId);
            this.reconStorage.persistCurrentState();
        }
        catch (IOException ex) {
            LOG.error("Failed to persist new cert ID {} to VERSION file.Terminating OzoneManager...", (Object)newCertId, (Object)ex);
            this.terminateRecon();
        }
    }

    public void terminateRecon() {
        this.stop();
        ExitUtil.terminate((int)1);
    }

    public void start() throws Exception {
        if (!this.isStarted) {
            LOG.info("Starting Recon server");
            this.isStarted = true;
            HddsServerUtil.initializeMetrics((OzoneConfiguration)this.configuration, (String)"Recon");
            if (this.reconTaskStatusMetrics != null) {
                this.reconTaskStatusMetrics.register();
            }
            if (this.httpServer != null) {
                this.httpServer.start();
            }
            if (this.ozoneManagerServiceProvider != null) {
                this.ozoneManagerServiceProvider.start();
            }
            if (this.reconStorageContainerManager != null) {
                this.reconStorageContainerManager.start();
            }
            if (this.jvmPauseMonitor != null) {
                this.jvmPauseMonitor.start();
            }
        }
    }

    public void stop() {
        if (this.isStarted) {
            LOG.info("Stopping Recon server");
            if (this.httpServer != null) {
                try {
                    this.httpServer.stop();
                }
                catch (Exception e) {
                    LOG.error("Stopping HttpServer is failed.", (Throwable)e);
                }
            }
            if (this.reconStorageContainerManager != null) {
                this.reconStorageContainerManager.stop();
            }
            if (this.ozoneManagerServiceProvider != null) {
                try {
                    this.ozoneManagerServiceProvider.stop();
                }
                catch (Exception e) {
                    LOG.error("Stopping ozoneManagerServiceProvider is failed.", (Throwable)e);
                }
            }
            if (this.reconTaskStatusMetrics != null) {
                this.reconTaskStatusMetrics.unregister();
            }
            this.isStarted = false;
            if (this.reconDBProvider != null) {
                try {
                    LOG.info("Closing Recon Container Key DB.");
                    this.reconDBProvider.close();
                }
                catch (Exception ex) {
                    LOG.error("Recon Container Key DB close failed", (Throwable)ex);
                }
            }
        }
        if (this.certClient != null) {
            try {
                this.certClient.close();
            }
            catch (IOException ioe) {
                LOG.error("Failed to close certificate client.", (Throwable)ioe);
            }
        }
        if (this.jvmPauseMonitor != null) {
            this.jvmPauseMonitor.stop();
        }
    }

    public void join() {
        if (this.reconStorageContainerManager != null) {
            this.reconStorageContainerManager.join();
        }
    }

    private static void loginReconUserIfSecurityEnabled(OzoneConfiguration conf) {
        try {
            if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)conf)) {
                ReconServer.loginReconUser(conf);
            }
        }
        catch (Exception ex) {
            LOG.error("Error login in as Recon service. ", (Throwable)ex);
        }
    }

    private static void loginReconUser(OzoneConfiguration conf) throws IOException, AuthenticationException {
        if (!SecurityUtil.getAuthenticationMethod((Configuration)conf).equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
            throw new AuthenticationException(SecurityUtil.getAuthenticationMethod((Configuration)conf) + " authentication method not supported. Recon service login failed.");
        }
        ReconConfig reconConfig = (ReconConfig)conf.getObject(ReconConfig.class);
        LOG.info("Ozone security is enabled. Attempting login for Recon service. Principal: {}, keytab: {}", (Object)reconConfig.getKerberosPrincipal(), (Object)reconConfig.getKerberosKeytab());
        UserGroupInformation.setConfiguration((Configuration)conf);
        InetSocketAddress socAddr = HddsUtils.getReconAddresses((ConfigurationSource)conf);
        SecurityUtil.login((Configuration)conf, (String)"ozone.recon.kerberos.keytab.file", (String)"ozone.recon.kerberos.principal", (String)socAddr.getHostName());
        LOG.info("Recon login successful.");
    }

    @VisibleForTesting
    public OzoneManagerServiceProvider getOzoneManagerServiceProvider() {
        return this.ozoneManagerServiceProvider;
    }

    @VisibleForTesting
    public OzoneStorageContainerManager getReconStorageContainerManager() {
        return this.reconStorageContainerManager;
    }

    @VisibleForTesting
    public StorageContainerServiceProvider getStorageContainerServiceProvider() {
        return (StorageContainerServiceProvider)this.injector.getInstance(StorageContainerServiceProvider.class);
    }

    @VisibleForTesting
    public ReconContainerMetadataManager getReconContainerMetadataManager() {
        return this.reconContainerMetadataManager;
    }

    @VisibleForTesting
    public ReconNamespaceSummaryManager getReconNamespaceSummaryManager() {
        return this.reconNamespaceSummaryManager;
    }

    @VisibleForTesting
    public ReconTaskController getReconTaskController() {
        return (ReconTaskController)this.injector.getInstance(ReconTaskController.class);
    }

    @VisibleForTesting
    ReconHttpServer getHttpServer() {
        return this.httpServer;
    }
}

