/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon;

import com.google.inject.Singleton;
import javax.ws.rs.core.Response;

@Singleton
public final class ReconResponseUtils {
    private ReconResponseUtils() {
    }

    public static Response noMatchedKeysResponse(String startPrefix) {
        String jsonResponse = String.format("{\"message\": \"No keys matched the search prefix: '%s'.\"}", startPrefix);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)jsonResponse).type("application/json").build();
    }

    public static Response createBadRequestResponse(String message) {
        String jsonResponse = String.format("{\"message\": \"%s\"}", message);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)jsonResponse).type("application/json").build();
    }

    public static Response createInternalServerErrorResponse(String message) {
        String jsonResponse = String.format("{\"message\": \"%s\"}", message);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)jsonResponse).type("application/json").build();
    }
}

