/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.cli.ContainerOperationClient;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.om.protocolPB.OmTransport;
import org.apache.hadoop.ozone.om.protocolPB.OmTransportFactory;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.recon.ConfigurationProvider;
import org.apache.hadoop.ozone.recon.MetricsServiceProviderFactory;
import org.apache.hadoop.ozone.recon.ReconContext;
import org.apache.hadoop.ozone.recon.ReconHttpServer;
import org.apache.hadoop.ozone.recon.ReconSqlDbConfig;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.heatmap.HeatMapServiceImpl;
import org.apache.hadoop.ozone.recon.persistence.ContainerHealthSchemaManager;
import org.apache.hadoop.ozone.recon.persistence.DataSourceConfiguration;
import org.apache.hadoop.ozone.recon.persistence.JooqPersistenceModule;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.recovery.ReconOmMetadataManagerImpl;
import org.apache.hadoop.ozone.recon.scm.ReconStorageConfig;
import org.apache.hadoop.ozone.recon.scm.ReconStorageContainerManagerFacade;
import org.apache.hadoop.ozone.recon.spi.OzoneManagerServiceProvider;
import org.apache.hadoop.ozone.recon.spi.ReconContainerMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconFileMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconGlobalStatsManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.apache.hadoop.ozone.recon.spi.StorageContainerServiceProvider;
import org.apache.hadoop.ozone.recon.spi.impl.OzoneManagerServiceProviderImpl;
import org.apache.hadoop.ozone.recon.spi.impl.ReconContainerMetadataManagerImpl;
import org.apache.hadoop.ozone.recon.spi.impl.ReconDBProvider;
import org.apache.hadoop.ozone.recon.spi.impl.ReconFileMetadataManagerImpl;
import org.apache.hadoop.ozone.recon.spi.impl.ReconGlobalStatsManagerImpl;
import org.apache.hadoop.ozone.recon.spi.impl.ReconNamespaceSummaryManagerImpl;
import org.apache.hadoop.ozone.recon.spi.impl.StorageContainerServiceProviderImpl;
import org.apache.hadoop.ozone.recon.tasks.ContainerKeyMapperTaskFSO;
import org.apache.hadoop.ozone.recon.tasks.ContainerKeyMapperTaskOBS;
import org.apache.hadoop.ozone.recon.tasks.FileSizeCountTaskFSO;
import org.apache.hadoop.ozone.recon.tasks.FileSizeCountTaskOBS;
import org.apache.hadoop.ozone.recon.tasks.NSSummaryTask;
import org.apache.hadoop.ozone.recon.tasks.OmTableInsightTask;
import org.apache.hadoop.ozone.recon.tasks.ReconOmTask;
import org.apache.hadoop.ozone.recon.tasks.ReconTaskController;
import org.apache.hadoop.ozone.recon.tasks.ReconTaskControllerImpl;
import org.apache.hadoop.ozone.recon.tasks.updater.ReconTaskStatusUpdaterManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ozone.recon.schema.generated.tables.daos.ClusterGrowthDailyDao;
import org.apache.ozone.recon.schema.generated.tables.daos.ContainerCountBySizeDao;
import org.apache.ozone.recon.schema.generated.tables.daos.FileCountBySizeDao;
import org.apache.ozone.recon.schema.generated.tables.daos.GlobalStatsDao;
import org.apache.ozone.recon.schema.generated.tables.daos.ReconTaskStatusDao;
import org.apache.ozone.recon.schema.generated.tables.daos.UnhealthyContainersDao;
import org.apache.ratis.protocol.ClientId;
import org.jooq.Configuration;
import org.jooq.DAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconControllerModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(ReconControllerModule.class);

    protected void configure() {
        this.bind(OzoneConfiguration.class).toProvider(ConfigurationProvider.class);
        this.bind(ReconHttpServer.class).in(Singleton.class);
        this.bind(ReconStorageConfig.class).in(Singleton.class);
        this.bind(ReconDBProvider.class).in(Singleton.class);
        this.bind(ReconOMMetadataManager.class).to(ReconOmMetadataManagerImpl.class);
        this.bind(OMMetadataManager.class).to(ReconOmMetadataManagerImpl.class);
        this.bind(ContainerHealthSchemaManager.class).in(Singleton.class);
        this.bind(ReconContainerMetadataManager.class).to(ReconContainerMetadataManagerImpl.class).in(Singleton.class);
        this.bind(ReconFileMetadataManager.class).to(ReconFileMetadataManagerImpl.class).in(Singleton.class);
        this.bind(ReconGlobalStatsManager.class).to(ReconGlobalStatsManagerImpl.class).in(Singleton.class);
        this.bind(ReconNamespaceSummaryManager.class).to(ReconNamespaceSummaryManagerImpl.class).in(Singleton.class);
        this.bind(OzoneManagerServiceProvider.class).to(OzoneManagerServiceProviderImpl.class).in(Singleton.class);
        this.bind(ReconUtils.class).in(Singleton.class);
        this.bind(ReconContext.class).in(Singleton.class);
        this.install((Module)new JooqPersistenceModule((Provider<DataSourceConfiguration>)this.getProvider(DataSourceConfiguration.class)));
        this.install((Module)new ReconOmTaskBindingModule());
        this.install((Module)new ReconDaoBindingModule());
        this.bind(ReconTaskStatusUpdaterManager.class).in(Singleton.class);
        this.bind(ReconTaskController.class).to(ReconTaskControllerImpl.class).in(Singleton.class);
        this.bind(StorageContainerServiceProvider.class).to(StorageContainerServiceProviderImpl.class).in(Singleton.class);
        this.bind(OzoneStorageContainerManager.class).to(ReconStorageContainerManagerFacade.class).in(Singleton.class);
        this.bind(MetricsServiceProviderFactory.class).in(Singleton.class);
        this.bind(HeatMapServiceImpl.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    public ExecutorService provideReconExecutorService() {
        return Executors.newFixedThreadPool(5);
    }

    @Provides
    OzoneManagerProtocol getOzoneManagerProtocol(OzoneConfiguration ozoneConfiguration) {
        OzoneManagerProtocolClientSideTranslatorPB ozoneManagerClient = null;
        try {
            ClientId clientId = ClientId.randomId();
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            String serviceId = OmUtils.getOzoneManagerServiceId((OzoneConfiguration)ozoneConfiguration);
            OmTransport transport = OmTransportFactory.create((ConfigurationSource)ozoneConfiguration, (UserGroupInformation)ugi, (String)serviceId);
            ozoneManagerClient = new OzoneManagerProtocolClientSideTranslatorPB(transport, clientId.toString());
        }
        catch (IOException ioEx) {
            LOG.error("Error in provisioning OzoneManagerProtocol ", (Throwable)ioEx);
        }
        return ozoneManagerClient;
    }

    @Provides
    StorageContainerLocationProtocol getSCMProtocol(OzoneConfiguration configuration) {
        StorageContainerLocationProtocol storageContainerLocationProtocol = null;
        storageContainerLocationProtocol = ContainerOperationClient.newContainerRpcClient((ConfigurationSource)configuration);
        return storageContainerLocationProtocol;
    }

    @Provides
    DataSourceConfiguration getDataSourceConfiguration(OzoneConfiguration ozoneConfiguration) {
        final ReconSqlDbConfig sqlDbConfig = (ReconSqlDbConfig)ozoneConfiguration.getObject(ReconSqlDbConfig.class);
        if (StringUtils.contains((CharSequence)sqlDbConfig.getJdbcUrl(), (CharSequence)"ozone.recon.db.dir")) {
            ReconUtils reconUtils = new ReconUtils();
            File reconDbDir = reconUtils.getReconDbDir((ConfigurationSource)ozoneConfiguration, "ozone.recon.db.dir");
            sqlDbConfig.setJdbcUrl("jdbc:derby:" + reconDbDir.getPath() + "/ozone_recon_derby.db");
        }
        return new DataSourceConfiguration(){

            @Override
            public String getDriverClass() {
                return sqlDbConfig.getDriverClass();
            }

            @Override
            public String getJdbcUrl() {
                return sqlDbConfig.getJdbcUrl();
            }

            @Override
            public String getUserName() {
                return sqlDbConfig.getUsername();
            }

            @Override
            public String getPassword() {
                return sqlDbConfig.getPassword();
            }

            @Override
            public boolean setAutoCommit() {
                return sqlDbConfig.isAutoCommit();
            }

            @Override
            public long getConnectionTimeout() {
                return sqlDbConfig.getConnectionTimeout();
            }

            @Override
            public String getSqlDialect() {
                return sqlDbConfig.getSqlDbDialect();
            }

            @Override
            public Integer getMaxActiveConnections() {
                return sqlDbConfig.getMaxActiveConnections();
            }

            @Override
            public long getMaxConnectionAge() {
                return sqlDbConfig.getConnectionMaxAge();
            }

            @Override
            public long getMaxIdleConnectionAge() {
                return sqlDbConfig.getConnectionIdleMaxAge();
            }

            @Override
            public String getConnectionTestStatement() {
                return sqlDbConfig.getIdleTestQuery();
            }

            @Override
            public long getIdleConnectionTestPeriod() {
                return sqlDbConfig.getConnectionIdleTestPeriod();
            }
        };
    }

    static class ReconOmTaskBindingModule
    extends AbstractModule {
        ReconOmTaskBindingModule() {
        }

        protected void configure() {
            Multibinder taskBinder = Multibinder.newSetBinder((Binder)this.binder(), ReconOmTask.class);
            taskBinder.addBinding().to(ContainerKeyMapperTaskFSO.class);
            taskBinder.addBinding().to(ContainerKeyMapperTaskOBS.class);
            taskBinder.addBinding().to(FileSizeCountTaskFSO.class);
            taskBinder.addBinding().to(FileSizeCountTaskOBS.class);
            taskBinder.addBinding().to(OmTableInsightTask.class);
            taskBinder.addBinding().to(NSSummaryTask.class);
        }
    }

    public static class ReconDaoBindingModule
    extends AbstractModule {
        public static final List<Class<? extends DAO>> RECON_DAO_LIST = ImmutableList.of(FileCountBySizeDao.class, ReconTaskStatusDao.class, UnhealthyContainersDao.class, GlobalStatsDao.class, ClusterGrowthDailyDao.class, ContainerCountBySizeDao.class);

        protected void configure() {
            RECON_DAO_LIST.forEach(aClass -> {
                try {
                    this.bind((Class)aClass).toConstructor(aClass.getConstructor(Configuration.class)).in(Singleton.class);
                }
                catch (NoSuchMethodException e) {
                    LOG.error("Error creating DAO {} ", (Object)aClass.getSimpleName(), (Object)e);
                }
            });
        }
    }
}

