/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security.acl;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IOzoneObj;
import org.apache.hadoop.ozone.security.acl.OzonePrefixPath;

public abstract class OzoneObj
implements IOzoneObj {
    private final ResourceType resType;
    private final StoreType storeType;

    OzoneObj(ResourceType resType, StoreType storeType) {
        Preconditions.checkNotNull((Object)((Object)resType));
        Preconditions.checkNotNull((Object)((Object)storeType));
        this.resType = resType;
        this.storeType = storeType;
    }

    public static OzoneManagerProtocolProtos.OzoneObj toProtobuf(OzoneObj obj) {
        return OzoneManagerProtocolProtos.OzoneObj.newBuilder().setResType(OzoneManagerProtocolProtos.OzoneObj.ObjectType.valueOf((String)obj.getResourceType().name())).setStoreType(OzoneManagerProtocolProtos.OzoneObj.StoreType.valueOf((String)obj.getStoreType().name())).setPath(obj.getPath()).build();
    }

    public ResourceType getResourceType() {
        return this.resType;
    }

    public String toString() {
        return "OzoneObj{resType=" + (Object)((Object)this.resType) + ", storeType=" + (Object)((Object)this.storeType) + ", path='" + this.getPath() + '\'' + '}';
    }

    public StoreType getStoreType() {
        return this.storeType;
    }

    public abstract String getVolumeName();

    public abstract String getBucketName();

    public abstract String getKeyName();

    public abstract OzonePrefixPath getOzonePrefixPathViewer();

    public abstract String getPrefixName();

    public abstract String getPath();

    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("resourceType", this.getResourceType().value);
        auditMap.put("storageType", this.getStoreType().value);
        auditMap.put("volume", this.getVolumeName());
        auditMap.put("bucket", this.getBucketName());
        auditMap.put("key", this.getKeyName());
        return auditMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OzoneObj that = (OzoneObj)o;
        return this.resType == that.resType && this.storeType == that.storeType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resType, this.storeType});
    }

    public static enum ResourceType {
        VOLUME("volume"),
        BUCKET("bucket"),
        KEY("key"),
        PREFIX("prefix");

        private final String value;

        public String toString() {
            return this.value;
        }

        private ResourceType(String resType) {
            this.value = resType;
        }
    }

    public static enum StoreType {
        OZONE("ozone"),
        S3("s3");

        private final String value;

        public String toString() {
            return this.value;
        }

        private StoreType(String objType) {
            this.value = objType;
        }
    }
}

