/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.MessageLite;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.DefaultReplicationConfig;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CopyObject;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.Auditable;
import org.apache.hadoop.ozone.om.helpers.BucketEncryptionKeyInfo;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;

public final class OmBucketInfo
extends WithObjectID
implements Auditable,
CopyObject<OmBucketInfo> {
    private static final Codec<OmBucketInfo> CODEC = new DelegatedCodec(Proto2Codec.get((MessageLite)OzoneManagerProtocolProtos.BucketInfo.getDefaultInstance()), OmBucketInfo::getFromProtobuf, OmBucketInfo::getProtobuf, OmBucketInfo.class);
    private final String volumeName;
    private final String bucketName;
    private final CopyOnWriteArrayList<OzoneAcl> acls;
    private final boolean isVersionEnabled;
    private final StorageType storageType;
    private final long creationTime;
    private long modificationTime;
    private final BucketEncryptionKeyInfo bekInfo;
    private final DefaultReplicationConfig defaultReplicationConfig;
    private final String sourceVolume;
    private final String sourceBucket;
    private long usedBytes;
    private long usedNamespace;
    private final long quotaInBytes;
    private final long quotaInNamespace;
    private long snapshotUsedBytes;
    private long snapshotUsedNamespace;
    private final BucketLayout bucketLayout;
    private String owner;

    private OmBucketInfo(Builder b) {
        super(b);
        this.volumeName = b.volumeName;
        this.bucketName = b.bucketName;
        this.acls = new CopyOnWriteArrayList(b.acls);
        this.isVersionEnabled = b.isVersionEnabled;
        this.storageType = b.storageType;
        this.creationTime = b.creationTime;
        this.modificationTime = b.modificationTime;
        this.bekInfo = b.bekInfo;
        this.sourceVolume = b.sourceVolume;
        this.sourceBucket = b.sourceBucket;
        this.usedBytes = b.usedBytes;
        this.usedNamespace = b.usedNamespace;
        this.snapshotUsedBytes = b.snapshotUsedBytes;
        this.snapshotUsedNamespace = b.snapshotUsedNamespace;
        this.quotaInBytes = b.quotaInBytes;
        this.quotaInNamespace = b.quotaInNamespace;
        this.bucketLayout = b.bucketLayout;
        this.owner = b.owner;
        this.defaultReplicationConfig = b.defaultReplicationConfig;
    }

    public static Codec<OmBucketInfo> getCodec() {
        return CODEC;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public List<OzoneAcl> getAcls() {
        return ImmutableList.copyOf(this.acls);
    }

    public boolean addAcl(OzoneAcl ozoneAcl) {
        return OzoneAclUtil.addAcl(this.acls, ozoneAcl);
    }

    public boolean removeAcl(OzoneAcl ozoneAcl) {
        return OzoneAclUtil.removeAcl(this.acls, ozoneAcl);
    }

    public boolean setAcls(List<OzoneAcl> ozoneAcls) {
        return OzoneAclUtil.setAcl(this.acls, ozoneAcls);
    }

    public boolean getIsVersionEnabled() {
        return this.isVersionEnabled;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public BucketEncryptionKeyInfo getEncryptionKeyInfo() {
        return this.bekInfo;
    }

    public BucketLayout getBucketLayout() {
        return this.bucketLayout;
    }

    public DefaultReplicationConfig getDefaultReplicationConfig() {
        return this.defaultReplicationConfig;
    }

    public String getSourceVolume() {
        return this.sourceVolume;
    }

    public String getSourceBucket() {
        return this.sourceBucket;
    }

    public long getTotalBucketSpace() {
        return this.usedBytes + this.snapshotUsedBytes;
    }

    public long getTotalBucketNamespace() {
        return this.usedNamespace + this.snapshotUsedNamespace;
    }

    public long getSnapshotUsedBytes() {
        return this.snapshotUsedBytes;
    }

    public long getSnapshotUsedNamespace() {
        return this.snapshotUsedNamespace;
    }

    public long getUsedBytes() {
        return this.usedBytes;
    }

    public long getUsedNamespace() {
        return this.usedNamespace;
    }

    public void incrUsedBytes(long bytes) {
        this.usedBytes += bytes;
    }

    public void decrUsedBytes(long bytes, boolean increasePendingDeleteBytes) {
        this.usedBytes -= bytes;
        if (increasePendingDeleteBytes) {
            this.incrSnapshotUsedBytes(bytes);
        }
    }

    private void incrSnapshotUsedBytes(long bytes) {
        this.snapshotUsedBytes += bytes;
    }

    public void incrUsedNamespace(long namespaceToUse) {
        this.usedNamespace += namespaceToUse;
    }

    public void decrUsedNamespace(long namespaceToUse, boolean increasePendingDeleteNamespace) {
        this.usedNamespace -= namespaceToUse;
        if (increasePendingDeleteNamespace) {
            this.incrSnapshotUsedNamespace(namespaceToUse);
        }
    }

    private void incrSnapshotUsedNamespace(long namespaceToUse) {
        this.snapshotUsedNamespace += namespaceToUse;
    }

    public void purgeSnapshotUsedBytes(long bytes) {
        this.snapshotUsedBytes -= bytes;
    }

    public void purgeSnapshotUsedNamespace(long namespaceToUse) {
        this.snapshotUsedNamespace -= namespaceToUse;
    }

    public long getQuotaInBytes() {
        return this.quotaInBytes;
    }

    public long getQuotaInNamespace() {
        return this.quotaInNamespace;
    }

    public boolean isLink() {
        return this.sourceVolume != null && this.sourceBucket != null;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    public void setOwner(String ownerName) {
        this.owner = ownerName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", this.volumeName);
        auditMap.put("bucket", this.bucketName);
        auditMap.put("bucketLayout", String.valueOf((Object)this.bucketLayout));
        auditMap.put("gdprEnabled", this.getMetadata().get("gdprEnabled"));
        auditMap.put("acls", this.acls != null ? this.acls.toString() : null);
        auditMap.put("isVersionEnabled", String.valueOf(this.isVersionEnabled));
        auditMap.put("storageType", this.storageType != null ? this.storageType.name() : null);
        auditMap.put("creationTime", String.valueOf(this.creationTime));
        auditMap.put("bucketEncryptionKey", this.bekInfo != null ? this.bekInfo.getKeyName() : null);
        auditMap.put("modificationTime", String.valueOf(this.modificationTime));
        if (this.isLink()) {
            auditMap.put("sourceVolume", this.sourceVolume);
            auditMap.put("sourceBucket", this.sourceBucket);
        }
        auditMap.put("usedBytes", String.valueOf(this.usedBytes));
        auditMap.put("usedNamespace", String.valueOf(this.usedNamespace));
        auditMap.put("snapshotUsedBytes", String.valueOf(this.snapshotUsedBytes));
        auditMap.put("snapshotUsedNamespace", String.valueOf(this.snapshotUsedNamespace));
        auditMap.put("owner", this.owner);
        auditMap.put("replicationType", this.defaultReplicationConfig != null ? String.valueOf(this.defaultReplicationConfig.getType()) : null);
        auditMap.put("replicationConfig", this.defaultReplicationConfig != null ? this.defaultReplicationConfig.getReplicationConfig().getReplication() : null);
        auditMap.put("quotaInBytes", String.valueOf(this.quotaInBytes));
        auditMap.put("quotaInNamespace", String.valueOf(this.quotaInNamespace));
        return auditMap;
    }

    public OmBucketInfo copyObject() {
        Builder builder = this.toBuilder();
        if (this.bekInfo != null) {
            builder.setBucketEncryptionKey(this.bekInfo.copy());
        }
        if (this.defaultReplicationConfig != null) {
            builder.setDefaultReplicationConfig(this.defaultReplicationConfig.copy());
        }
        return builder.build();
    }

    public Builder toBuilder() {
        return new Builder(this).setVolumeName(this.volumeName).setBucketName(this.bucketName).setStorageType(this.storageType).setIsVersionEnabled(this.isVersionEnabled).setCreationTime(this.creationTime).setModificationTime(this.modificationTime).setBucketEncryptionKey(this.bekInfo).setSourceVolume(this.sourceVolume).setSourceBucket(this.sourceBucket).setAcls(this.acls).setUsedBytes(this.usedBytes).setUsedNamespace(this.usedNamespace).setQuotaInBytes(this.quotaInBytes).setQuotaInNamespace(this.quotaInNamespace).setSnapshotUsedBytes(this.snapshotUsedBytes).setSnapshotUsedNamespace(this.snapshotUsedNamespace).setBucketLayout(this.bucketLayout).setOwner(this.owner).setDefaultReplicationConfig(this.defaultReplicationConfig);
    }

    public OzoneManagerProtocolProtos.BucketInfo getProtobuf() {
        OzoneManagerProtocolProtos.BucketInfo.Builder bib = OzoneManagerProtocolProtos.BucketInfo.newBuilder().setVolumeName(this.volumeName).setBucketName(this.bucketName).addAllAcls(OzoneAclUtil.toProtobuf(this.acls)).setIsVersionEnabled(this.isVersionEnabled).setStorageType(this.storageType.toProto()).setCreationTime(this.creationTime).setModificationTime(this.modificationTime).setObjectID(this.getObjectID()).setUpdateID(this.getUpdateID()).setUsedBytes(this.usedBytes).setUsedNamespace(this.usedNamespace).addAllMetadata(KeyValueUtil.toProtobuf(this.getMetadata())).setQuotaInBytes(this.quotaInBytes).setQuotaInNamespace(this.quotaInNamespace).setSnapshotUsedBytes(this.snapshotUsedBytes).setSnapshotUsedNamespace(this.snapshotUsedNamespace);
        if (this.bucketLayout != null) {
            bib.setBucketLayout(this.bucketLayout.toProto());
        }
        if (this.bekInfo != null && this.bekInfo.getKeyName() != null) {
            bib.setBeinfo(OMPBHelper.convert(this.bekInfo));
        }
        if (this.defaultReplicationConfig != null) {
            bib.setDefaultReplicationConfig(this.defaultReplicationConfig.toProto());
        }
        if (this.sourceVolume != null) {
            bib.setSourceVolume(this.sourceVolume);
        }
        if (this.sourceBucket != null) {
            bib.setSourceBucket(this.sourceBucket);
        }
        if (this.owner != null) {
            bib.setOwner(this.owner);
        }
        return bib.build();
    }

    public static OmBucketInfo getFromProtobuf(OzoneManagerProtocolProtos.BucketInfo bucketInfo) {
        return OmBucketInfo.getFromProtobuf(bucketInfo, null);
    }

    public static OmBucketInfo getFromProtobuf(OzoneManagerProtocolProtos.BucketInfo bucketInfo, BucketLayout buckLayout) {
        Builder obib = OmBucketInfo.newBuilder().setVolumeName(bucketInfo.getVolumeName()).setBucketName(bucketInfo.getBucketName()).setAcls(bucketInfo.getAclsList().stream().map(OzoneAcl::fromProtobuf).collect(Collectors.toList())).setIsVersionEnabled(bucketInfo.getIsVersionEnabled()).setStorageType(StorageType.valueOf(bucketInfo.getStorageType())).setCreationTime(bucketInfo.getCreationTime()).setUsedBytes(bucketInfo.getUsedBytes()).setModificationTime(bucketInfo.getModificationTime()).setQuotaInBytes(bucketInfo.getQuotaInBytes()).setUsedNamespace(bucketInfo.getUsedNamespace()).setQuotaInNamespace(bucketInfo.getQuotaInNamespace()).setSnapshotUsedBytes(bucketInfo.getSnapshotUsedBytes()).setSnapshotUsedNamespace(bucketInfo.getSnapshotUsedNamespace());
        if (buckLayout != null) {
            obib.setBucketLayout(buckLayout);
        } else if (bucketInfo.getBucketLayout() != null) {
            obib.setBucketLayout(BucketLayout.fromProto(bucketInfo.getBucketLayout()));
        }
        if (bucketInfo.hasDefaultReplicationConfig()) {
            obib.setDefaultReplicationConfig(DefaultReplicationConfig.fromProto((HddsProtos.DefaultReplicationConfig)bucketInfo.getDefaultReplicationConfig()));
        }
        if (bucketInfo.hasObjectID()) {
            obib.setObjectID(bucketInfo.getObjectID());
        }
        if (bucketInfo.hasUpdateID()) {
            obib.setUpdateID(bucketInfo.getUpdateID());
        }
        if (bucketInfo.getMetadataList() != null) {
            obib.addAllMetadata((Map)KeyValueUtil.getFromProtobuf(bucketInfo.getMetadataList()));
        }
        if (bucketInfo.hasBeinfo()) {
            obib.setBucketEncryptionKey(OMPBHelper.convert(bucketInfo.getBeinfo()));
        }
        if (bucketInfo.hasSourceVolume()) {
            obib.setSourceVolume(bucketInfo.getSourceVolume());
        }
        if (bucketInfo.hasSourceBucket()) {
            obib.setSourceBucket(bucketInfo.getSourceBucket());
        }
        if (bucketInfo.hasOwner()) {
            obib.setOwner(bucketInfo.getOwner());
        }
        return obib.build();
    }

    @Override
    public String getObjectInfo() {
        String sourceInfo = this.sourceVolume != null && this.sourceBucket != null ? ", source='" + this.sourceVolume + "/" + this.sourceBucket + "'" : "";
        return "OMBucketInfo{volume='" + this.volumeName + "', bucket='" + this.bucketName + "', isVersionEnabled='" + this.isVersionEnabled + "', storageType='" + (Object)((Object)this.storageType) + "', creationTime='" + this.creationTime + "', usedBytes='" + this.usedBytes + "', usedNamespace='" + this.usedNamespace + "', quotaInBytes='" + this.quotaInBytes + "', quotaInNamespace='" + this.quotaInNamespace + "', bucketLayout='" + (Object)((Object)this.bucketLayout) + '\'' + ", defaultReplicationConfig='" + this.defaultReplicationConfig + '\'' + sourceInfo + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OmBucketInfo that = (OmBucketInfo)o;
        return this.creationTime == that.creationTime && this.modificationTime == that.modificationTime && this.volumeName.equals(that.volumeName) && this.bucketName.equals(that.bucketName) && Objects.equals(this.acls, that.acls) && Objects.equals(this.isVersionEnabled, that.isVersionEnabled) && this.storageType == that.storageType && this.getObjectID() == that.getObjectID() && this.getUpdateID() == that.getUpdateID() && this.usedBytes == that.usedBytes && this.usedNamespace == that.usedNamespace && this.snapshotUsedBytes == that.snapshotUsedBytes && this.snapshotUsedNamespace == that.snapshotUsedNamespace && Objects.equals(this.sourceVolume, that.sourceVolume) && Objects.equals(this.sourceBucket, that.sourceBucket) && Objects.equals(this.getMetadata(), that.getMetadata()) && Objects.equals(this.bekInfo, that.bekInfo) && Objects.equals(this.owner, that.owner) && Objects.equals(this.defaultReplicationConfig, that.defaultReplicationConfig);
    }

    public int hashCode() {
        return Objects.hash(this.volumeName, this.bucketName);
    }

    public String toString() {
        return "OmBucketInfo{volumeName='" + this.volumeName + "', bucketName='" + this.bucketName + "', acls=" + this.acls + ", isVersionEnabled=" + this.isVersionEnabled + ", storageType=" + (Object)((Object)this.storageType) + ", creationTime=" + this.creationTime + ", bekInfo=" + this.bekInfo + ", sourceVolume='" + this.sourceVolume + "', sourceBucket='" + this.sourceBucket + "', objectID=" + this.getObjectID() + ", updateID=" + this.getUpdateID() + ", metadata=" + this.getMetadata() + ", usedBytes=" + this.usedBytes + ", usedNamespace=" + this.usedNamespace + ", snapshotUsedBytes=" + this.snapshotUsedBytes + ", snapshotUsedNamespace=" + this.snapshotUsedNamespace + ", quotaInBytes=" + this.quotaInBytes + ", quotaInNamespace=" + this.quotaInNamespace + ", bucketLayout=" + (Object)((Object)this.bucketLayout) + ", owner=" + this.owner + ", defaultReplicationConfig=" + this.defaultReplicationConfig + '}';
    }

    public static class Builder
    extends WithObjectID.Builder {
        private String volumeName;
        private String bucketName;
        private final List<OzoneAcl> acls = new ArrayList<OzoneAcl>();
        private boolean isVersionEnabled;
        private StorageType storageType = StorageType.DISK;
        private long creationTime;
        private long modificationTime;
        private BucketEncryptionKeyInfo bekInfo;
        private String sourceVolume;
        private String sourceBucket;
        private long usedBytes;
        private long usedNamespace;
        private long quotaInBytes = -1L;
        private long quotaInNamespace = -1L;
        private BucketLayout bucketLayout = BucketLayout.DEFAULT;
        private String owner;
        private DefaultReplicationConfig defaultReplicationConfig;
        private long snapshotUsedBytes;
        private long snapshotUsedNamespace;

        public Builder() {
        }

        private Builder(OmBucketInfo obj) {
            super(obj);
        }

        public Builder setVolumeName(String volume) {
            this.volumeName = volume;
            return this;
        }

        public Builder setBucketName(String bucket) {
            this.bucketName = bucket;
            return this;
        }

        public Builder setAcls(List<OzoneAcl> listOfAcls) {
            if (listOfAcls != null) {
                this.acls.addAll(listOfAcls);
            }
            return this;
        }

        public List<OzoneAcl> getAcls() {
            return this.acls;
        }

        public Builder addAcl(OzoneAcl ozoneAcl) {
            if (ozoneAcl != null) {
                this.acls.add(ozoneAcl);
            }
            return this;
        }

        public Builder setIsVersionEnabled(boolean versionFlag) {
            this.isVersionEnabled = versionFlag;
            return this;
        }

        public Builder setStorageType(StorageType storage) {
            this.storageType = storage;
            return this;
        }

        public Builder setCreationTime(long createdOn) {
            this.creationTime = createdOn;
            return this;
        }

        public Builder setModificationTime(long modifiedOn) {
            this.modificationTime = modifiedOn;
            return this;
        }

        @Override
        public Builder setObjectID(long obId) {
            super.setObjectID(obId);
            return this;
        }

        @Override
        public Builder setUpdateID(long id) {
            super.setUpdateID(id);
            return this;
        }

        @Override
        public Builder addMetadata(String key, String value) {
            super.addMetadata(key, value);
            return this;
        }

        @Override
        public Builder addAllMetadata(Map<String, String> additionalMetadata) {
            super.addAllMetadata(additionalMetadata);
            return this;
        }

        public Builder setBucketEncryptionKey(BucketEncryptionKeyInfo info) {
            this.bekInfo = info;
            return this;
        }

        public Builder setSourceVolume(String volume) {
            this.sourceVolume = volume;
            return this;
        }

        public Builder setSourceBucket(String bucket) {
            this.sourceBucket = bucket;
            return this;
        }

        public Builder setUsedBytes(long quotaUsage) {
            this.usedBytes = quotaUsage;
            return this;
        }

        public Builder setUsedNamespace(long quotaUsage) {
            this.usedNamespace = quotaUsage;
            return this;
        }

        public Builder setSnapshotUsedBytes(long snapshotUsedBytes) {
            this.snapshotUsedBytes = snapshotUsedBytes;
            return this;
        }

        public Builder setSnapshotUsedNamespace(long snapshotUsedNamespace) {
            this.snapshotUsedNamespace = snapshotUsedNamespace;
            return this;
        }

        public Builder setQuotaInBytes(long quota) {
            this.quotaInBytes = quota;
            return this;
        }

        public Builder setQuotaInNamespace(long quota) {
            this.quotaInNamespace = quota;
            return this;
        }

        public Builder setBucketLayout(BucketLayout type) {
            this.bucketLayout = type;
            return this;
        }

        public Builder setOwner(String ownerName) {
            this.owner = ownerName;
            return this;
        }

        public Builder setDefaultReplicationConfig(DefaultReplicationConfig defaultReplConfig) {
            this.defaultReplicationConfig = defaultReplConfig;
            return this;
        }

        public OmBucketInfo build() {
            Preconditions.checkNotNull((Object)this.volumeName);
            Preconditions.checkNotNull((Object)this.bucketName);
            Preconditions.checkNotNull(this.acls);
            Preconditions.checkNotNull((Object)((Object)this.storageType));
            return new OmBucketInfo(this);
        }
    }
}

