/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public final class KeyValueUtil {
    private KeyValueUtil() {
    }

    public static Map<String, String> getFromProtobuf(List<HddsProtos.KeyValue> keyValueList) {
        return keyValueList.stream().collect(Collectors.toMap(HddsProtos.KeyValue::getKey, HddsProtos.KeyValue::getValue));
    }

    public static List<HddsProtos.KeyValue> toProtobuf(Map<String, String> keyValueMap) {
        LinkedList<HddsProtos.KeyValue> metadataList = new LinkedList<HddsProtos.KeyValue>();
        for (Map.Entry<String, String> entry : keyValueMap.entrySet()) {
            metadataList.add(HddsProtos.KeyValue.newBuilder().setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        return metadataList;
    }
}

