/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.ByteBufferReadable;

public class LengthInputStream
extends FilterInputStream
implements ByteBufferReadable {
    private final long length;

    public LengthInputStream(InputStream in, long length) {
        super(in);
        this.length = length;
    }

    public long getLength() {
        return this.length;
    }

    public InputStream getWrappedStream() {
        return this.in;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.in instanceof ByteBufferReadable) {
            return ((ByteBufferReadable)this.in).read(byteBuffer);
        }
        throw new UnsupportedOperationException("Read with ByteBuffer is not  supported by " + this.in.getClass().getName());
    }
}

