/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.DatanodeID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeMetric;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeStat;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.node.DatanodeInfo;
import org.apache.hadoop.hdds.scm.node.DatanodeUsageInfo;
import org.apache.hadoop.hdds.scm.node.NodeManagerMXBean;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.ozone.container.upgrade.UpgradeUtils;
import org.apache.hadoop.ozone.protocol.StorageContainerNodeProtocol;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.RegisteredCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;

public interface NodeManager
extends StorageContainerNodeProtocol,
EventHandler<CommandForDatanode>,
NodeManagerMXBean,
Closeable {
    default public RegisteredCommand register(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReport, StorageContainerDatanodeProtocolProtos.PipelineReportsProto pipelineReportsProto) {
        return this.register(datanodeDetails, nodeReport, pipelineReportsProto, UpgradeUtils.defaultLayoutVersionProto());
    }

    default public void registerSendCommandNotify(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type type, BiConsumer<DatanodeDetails, SCMCommand<?>> scmCommand) {
    }

    public List<DatanodeDetails> getNodes(NodeStatus var1);

    public List<DatanodeDetails> getNodes(HddsProtos.NodeOperationalState var1, HddsProtos.NodeState var2);

    public int getNodeCount(NodeStatus var1);

    public int getNodeCount(HddsProtos.NodeOperationalState var1, HddsProtos.NodeState var2);

    public List<? extends DatanodeDetails> getAllNodes();

    default public int getAllNodeCount() {
        return this.getAllNodes().size();
    }

    public SCMNodeStat getStats();

    public Map<DatanodeDetails, SCMNodeStat> getNodeStats();

    public List<DatanodeUsageInfo> getMostOrLeastUsedDatanodes(boolean var1);

    public DatanodeUsageInfo getUsageInfo(DatanodeDetails var1);

    public SCMNodeMetric getNodeStat(DatanodeDetails var1);

    public NodeStatus getNodeStatus(DatanodeDetails var1) throws NodeNotFoundException;

    public void setNodeOperationalState(DatanodeDetails var1, HddsProtos.NodeOperationalState var2) throws NodeNotFoundException;

    public void setNodeOperationalState(DatanodeDetails var1, HddsProtos.NodeOperationalState var2, long var3) throws NodeNotFoundException;

    public Set<PipelineID> getPipelines(DatanodeDetails var1);

    public int getPipelinesCount(DatanodeDetails var1);

    public void addPipeline(Pipeline var1);

    public void removePipeline(Pipeline var1);

    public void addContainer(DatanodeDetails var1, ContainerID var2) throws NodeNotFoundException;

    public void removeContainer(DatanodeDetails var1, ContainerID var2) throws NodeNotFoundException;

    public Set<ContainerID> getContainers(DatanodeDetails var1) throws NodeNotFoundException;

    public void addDatanodeCommand(DatanodeID var1, SCMCommand<?> var2);

    public void refreshAllHealthyDnUsageInfo();

    public void processNodeReport(DatanodeDetails var1, StorageContainerDatanodeProtocolProtos.NodeReportProto var2);

    public void processLayoutVersionReport(DatanodeDetails var1, StorageContainerDatanodeProtocolProtos.LayoutVersionProto var2);

    public int getNodeQueuedCommandCount(DatanodeDetails var1, StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type var2) throws NodeNotFoundException;

    public int getCommandQueueCount(DatanodeID var1, StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type var2);

    public int getTotalDatanodeCommandCount(DatanodeDetails var1, StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type var2) throws NodeNotFoundException;

    public Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, Integer> getTotalDatanodeCommandCounts(DatanodeDetails var1, StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type ... var2) throws NodeNotFoundException;

    public List<SCMCommand<?>> getCommandQueue(DatanodeID var1);

    @Nullable
    public DatanodeDetails getNode(@Nullable DatanodeID var1);

    @Nullable
    public DatanodeInfo getDatanodeInfo(DatanodeDetails var1);

    public List<DatanodeDetails> getNodesByAddress(String var1);

    public long getLastHeartbeat(DatanodeDetails var1);

    public NetworkTopology getClusterNetworkTopologyMap();

    public int minHealthyVolumeNum(List<DatanodeDetails> var1);

    public int totalHealthyVolumeCount();

    public int pipelineLimit(DatanodeDetails var1);

    public int minPipelineLimit(List<DatanodeDetails> var1);

    default public Collection<DatanodeDetails> getPeerList(DatanodeDetails dn) {
        return null;
    }

    default public HDDSLayoutVersionManager getLayoutVersionManager() {
        return null;
    }

    default public void forceNodesToHealthyReadOnly() {
    }

    default public void removeNode(DatanodeDetails datanodeDetails) throws NodeNotFoundException, IOException {
    }
}

