/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.states;

import java.util.List;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.states.ContainerAttribute;
import org.apache.hadoop.hdds.scm.container.states.ContainerEntry;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerStateMap {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerStateMap.class);
    private final ContainerAttribute<HddsProtos.LifeCycleState> lifeCycleStateMap = new ContainerAttribute<HddsProtos.LifeCycleState>(HddsProtos.LifeCycleState.class);
    private final ContainerAttribute<HddsProtos.ReplicationType> typeMap = new ContainerAttribute<HddsProtos.ReplicationType>(HddsProtos.ReplicationType.class);
    private final ContainerMap containerMap = new ContainerMap();

    public void addContainer(ContainerInfo info) {
        Objects.requireNonNull(info, "info == null");
        if (this.containerMap.addIfAbsent(info)) {
            this.lifeCycleStateMap.addNonExisting(info.getState(), info);
            this.typeMap.addNonExisting(info.getReplicationType(), info);
            LOG.trace("Added {}", (Object)info);
        }
    }

    public boolean contains(ContainerID id) {
        return this.containerMap.contains(id);
    }

    public void removeContainer(ContainerID id) {
        Objects.requireNonNull(id, "id == null");
        ContainerInfo info = this.containerMap.remove(id);
        if (info != null) {
            this.lifeCycleStateMap.removeExisting(info.getState(), info);
            this.typeMap.removeExisting(info.getReplicationType(), info);
            LOG.trace("Removed {}", (Object)info);
        }
    }

    public ContainerInfo getContainerInfo(ContainerID containerID) {
        return this.containerMap.getInfo(containerID);
    }

    public Set<ContainerReplica> getContainerReplicas(ContainerID containerID) {
        Objects.requireNonNull(containerID, "containerID == null");
        return this.containerMap.getReplicas(containerID);
    }

    public void updateContainerReplica(ContainerReplica replica) {
        Objects.requireNonNull(replica, "replica == null");
        this.containerMap.put(replica);
    }

    public void removeContainerReplica(ContainerID containerID, DatanodeID datanodeID) {
        Objects.requireNonNull(containerID, "containerID == null");
        Objects.requireNonNull(datanodeID, "datanodeID == null");
        this.containerMap.removeReplica(containerID, datanodeID);
    }

    public void updateState(ContainerID containerID, HddsProtos.LifeCycleState currentState, HddsProtos.LifeCycleState newState) throws SCMException {
        if (currentState == newState) {
            return;
        }
        ContainerInfo currentInfo = this.containerMap.getInfo(containerID);
        if (currentInfo == null) {
            return;
        }
        this.lifeCycleStateMap.update(currentState, newState, containerID);
        LOG.trace("Updated the container {} from {} to {}", new Object[]{containerID, currentState, newState});
        currentInfo.setState(newState);
    }

    public List<ContainerInfo> getContainerInfos(ContainerID start, int count) {
        return this.containerMap.getInfos(start, count);
    }

    public List<ContainerInfo> getContainerInfos(HddsProtos.LifeCycleState state, ContainerID start, int count) {
        Preconditions.assertTrue((count >= 0 ? 1 : 0) != 0, (Object)"count < 0");
        return this.lifeCycleStateMap.tailMap(state, start).values().stream().limit(count).collect(Collectors.toList());
    }

    public List<ContainerInfo> getContainerInfos(HddsProtos.LifeCycleState state) {
        return this.lifeCycleStateMap.getCollection(state);
    }

    public List<ContainerInfo> getContainerInfos(HddsProtos.ReplicationType type) {
        return this.typeMap.getCollection(type);
    }

    public int getContainerCount(HddsProtos.LifeCycleState state) {
        return this.lifeCycleStateMap.count(state);
    }

    private static class ContainerMap {
        private final NavigableMap<ContainerID, ContainerEntry> map = new TreeMap<ContainerID, ContainerEntry>();

        private ContainerMap() {
        }

        boolean contains(ContainerID id) {
            return this.map.containsKey(id);
        }

        ContainerInfo getInfo(ContainerID id) {
            ContainerEntry entry = (ContainerEntry)this.map.get(id);
            return entry == null ? null : entry.getInfo();
        }

        List<ContainerInfo> getInfos(ContainerID start, int count) {
            Objects.requireNonNull(start, "start == null");
            Preconditions.assertTrue((count >= 0 ? 1 : 0) != 0, (Object)"count < 0");
            return this.map.tailMap(start).values().stream().map(ContainerEntry::getInfo).limit(count).collect(Collectors.toList());
        }

        Set<ContainerReplica> getReplicas(ContainerID id) {
            Objects.requireNonNull(id, "id == null");
            ContainerEntry entry = (ContainerEntry)this.map.get(id);
            return entry == null ? null : entry.getReplicas();
        }

        boolean addIfAbsent(ContainerInfo info) {
            Objects.requireNonNull(info, "info == null");
            ContainerID id = info.containerID();
            if (this.map.containsKey(id)) {
                return false;
            }
            ContainerEntry previous = this.map.put(id, new ContainerEntry(info));
            Preconditions.assertNull((Object)previous, (String)"previous");
            return true;
        }

        ContainerReplica put(ContainerReplica replica) {
            Objects.requireNonNull(replica, "replica == null");
            ContainerEntry entry = (ContainerEntry)this.map.get(replica.getContainerID());
            return entry == null ? null : entry.put(replica);
        }

        ContainerInfo remove(ContainerID id) {
            Objects.requireNonNull(id, "id == null");
            ContainerEntry removed = (ContainerEntry)this.map.remove(id);
            return removed == null ? null : removed.getInfo();
        }

        ContainerReplica removeReplica(ContainerID containerID, DatanodeID datanodeID) {
            Objects.requireNonNull(containerID, "containerID == null");
            Objects.requireNonNull(datanodeID, "datanodeID == null");
            ContainerEntry entry = (ContainerEntry)this.map.get(containerID);
            return entry == null ? null : entry.removeReplica(datanodeID);
        }
    }
}

