/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.placement.algorithms;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;

public class ContainerPlacementStatusDefault
implements ContainerPlacementStatus {
    private final int requiredRacks;
    private final int currentRacks;
    private final int totalRacks;
    private final int maxReplicasPerRack;
    private final List<Integer> rackReplicaCnts;

    public ContainerPlacementStatusDefault(int currentRacks, int requiredRacks, int totalRacks, int maxReplicasPerRack, List<Integer> rackReplicaCnts) {
        this.requiredRacks = requiredRacks;
        this.currentRacks = currentRacks;
        this.totalRacks = totalRacks;
        this.maxReplicasPerRack = maxReplicasPerRack;
        this.rackReplicaCnts = rackReplicaCnts;
    }

    public ContainerPlacementStatusDefault(int currentRacks, int requiredRacks, int totalRacks) {
        this(currentRacks, requiredRacks, totalRacks, 1, currentRacks == 0 ? Collections.emptyList() : Collections.nCopies(currentRacks, 1));
    }

    public boolean isPolicySatisfied() {
        if (this.currentRacks < Math.min(this.totalRacks, this.requiredRacks)) {
            return false;
        }
        return this.rackReplicaCnts.stream().allMatch(cnt -> cnt <= this.maxReplicasPerRack);
    }

    public String misReplicatedReason() {
        if (this.isPolicySatisfied()) {
            return null;
        }
        if (this.currentRacks < this.expectedPlacementCount()) {
            return "The container is mis-replicated as it is on " + this.currentRacks + " racks but should be on " + this.expectedPlacementCount() + " racks.";
        }
        return "The container is mis-replicated as max number of replicas per rack is " + this.maxReplicasPerRack + " but number of replicas per rack are " + this.rackReplicaCnts.toString();
    }

    public int misReplicationCount() {
        if (this.isPolicySatisfied()) {
            return 0;
        }
        return Math.max(this.expectedPlacementCount() - this.currentRacks, this.rackReplicaCnts.stream().mapToInt(cnt -> Math.max(cnt - this.maxReplicasPerRack, 0)).sum());
    }

    public int expectedPlacementCount() {
        return Math.min(this.requiredRacks, this.totalRacks);
    }

    public int actualPlacementCount() {
        return this.currentRacks;
    }
}

