/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Name;
import org.jooq.Param;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.DSL;
import org.jooq.impl.Fields;
import org.jooq.impl.RecordImpl;

final class ArrayTableEmulation
extends AbstractTable<Record> {
    private static final long serialVersionUID = 2392515064450536343L;
    private final Object[] array;
    private final Fields<Record> field;
    private final Name alias;
    private final Name fieldAlias;
    private transient Table<Record> table;

    ArrayTableEmulation(Object[] array) {
        this(array, DSL.name("array_table"), null);
    }

    ArrayTableEmulation(Object[] array, Name alias) {
        this(array, alias, null);
    }

    ArrayTableEmulation(Object[] array, Name alias, Name fieldAlias) {
        super(alias);
        this.array = array;
        this.alias = alias;
        this.fieldAlias = fieldAlias == null ? DSL.name("COLUMN_VALUE") : fieldAlias;
        this.field = new Fields(DSL.field(DSL.name(alias.last(), this.fieldAlias.last()), DSL.getDataType(array.getClass().getComponentType())));
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImpl.class;
    }

    @Override
    public final Table<Record> as(Name as) {
        return new ArrayTableEmulation(this.array, as);
    }

    @Override
    public final Table<Record> as(Name as, Name ... fieldAliases) {
        if (fieldAliases == null) {
            return new ArrayTableEmulation(this.array, as);
        }
        if (fieldAliases.length == 1) {
            return new ArrayTableEmulation(this.array, as, fieldAliases[0]);
        }
        throw new IllegalArgumentException("Array table simulations can only have a single field alias");
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.table(ctx.configuration()));
    }

    @Override
    final Fields<Record> fields0() {
        return this.field;
    }

    private final Table<Record> table(Configuration configuration) {
        if (this.table == null) {
            Select<Record> select = null;
            for (Object element : this.array) {
                Param<?> val = DSL.val(element, this.field.fields[0].getDataType());
                SelectSelectStep<Record> subselect = DSL.using(configuration).select(val.as("COLUMN_VALUE")).select(new SelectFieldOrAsterisk[0]);
                select = select == null ? subselect : select.unionAll(subselect);
            }
            if (select == null) {
                select = DSL.using(configuration).select(DSL.one().as("COLUMN_VALUE")).select(new SelectFieldOrAsterisk[0]).where((Condition)DSL.falseCondition());
            }
            this.table = DSL.table(select).as(this.alias);
        }
        return this.table;
    }
}

