/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security.acl;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.server.OzoneAdmins;
import org.apache.hadoop.ozone.om.BucketManager;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OzoneAclUtils;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PrefixManager;
import org.apache.hadoop.ozone.om.VolumeManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.IOzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneManagerAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "Yarn", "Ranger", "Hive", "HBase"})
@InterfaceStability.Evolving
public class OzoneNativeAuthorizer
implements OzoneManagerAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneNativeAuthorizer.class);
    private static final Predicate<UserGroupInformation> NO_ADMIN = any -> false;
    private VolumeManager volumeManager;
    private BucketManager bucketManager;
    private KeyManager keyManager;
    private PrefixManager prefixManager;
    private Predicate<UserGroupInformation> adminCheck = NO_ADMIN;
    private Predicate<UserGroupInformation> readOnlyAdminCheck = NO_ADMIN;
    private BooleanSupplier allowListAllVolumes = () -> false;

    public OzoneNativeAuthorizer() {
    }

    OzoneNativeAuthorizer(VolumeManager volumeManager, BucketManager bucketManager, KeyManager keyManager, PrefixManager prefixManager, OzoneAdmins ozoneAdmins) {
        this.volumeManager = volumeManager;
        this.bucketManager = bucketManager;
        this.keyManager = keyManager;
        this.prefixManager = prefixManager;
        this.adminCheck = arg_0 -> ((OzoneAdmins)ozoneAdmins).isAdmin(arg_0);
    }

    public boolean isNative() {
        return true;
    }

    public boolean checkAccess(IOzoneObj ozObject, RequestContext context) throws OMException {
        boolean isListAllVolume;
        boolean isACLTypeCreate;
        Objects.requireNonNull(ozObject);
        Objects.requireNonNull(context);
        boolean bl = isACLTypeCreate = context.getAclRights() == IAccessAuthorizer.ACLType.CREATE;
        if (!(ozObject instanceof OzoneObjInfo)) {
            throw new OMException("Unexpected input received. OM native acls are configured to work with OzoneObjInfo type only.", OMException.ResultCodes.INVALID_REQUEST);
        }
        OzoneObjInfo objInfo = (OzoneObjInfo)ozObject;
        if (this.adminCheck.test(context.getClientUgi())) {
            return true;
        }
        if (this.readOnlyAdminCheck.test(context.getClientUgi()) && (context.getAclRights() == IAccessAuthorizer.ACLType.READ || context.getAclRights() == IAccessAuthorizer.ACLType.READ_ACL || context.getAclRights() == IAccessAuthorizer.ACLType.LIST)) {
            return true;
        }
        boolean isOwner = OzoneNativeAuthorizer.isOwner(context.getClientUgi(), context.getOwnerName());
        boolean bl2 = isListAllVolume = context.getAclRights() == IAccessAuthorizer.ACLType.LIST && objInfo.getVolumeName().equals("/");
        if (isListAllVolume) {
            return this.getAllowListAllVolumes();
        }
        IAccessAuthorizer.ACLType parentAclRight = OzoneAclUtils.getParentNativeAcl(context.getAclRights(), objInfo.getResourceType());
        RequestContext parentContext = RequestContext.newBuilder().setClientUgi(context.getClientUgi()).setIp(context.getIp()).setAclType(context.getAclType()).setAclRights(parentAclRight).build();
        RequestContext parentVolContext = RequestContext.newBuilder().setClientUgi(context.getClientUgi()).setIp(context.getIp()).setAclType(context.getAclType()).setAclRights(IAccessAuthorizer.ACLType.READ).build();
        switch (objInfo.getResourceType()) {
            case VOLUME: {
                LOG.trace("Checking access for volume: {}", (Object)objInfo);
                if (isACLTypeCreate) {
                    return false;
                }
                return isOwner || this.volumeManager.checkAccess((OzoneObj)objInfo, context);
            }
            case BUCKET: {
                boolean bucketAccess;
                LOG.trace("Checking access for bucket: {}", (Object)objInfo);
                if (isOwner) {
                    return true;
                }
                boolean bl3 = bucketAccess = isACLTypeCreate || this.bucketManager.checkAccess((OzoneObj)objInfo, context);
                return bucketAccess && this.volumeManager.checkAccess((OzoneObj)objInfo, parentContext);
            }
            case KEY: {
                boolean keyAccess;
                LOG.trace("Checking access for Key: {}", (Object)objInfo);
                if (isOwner) {
                    return true;
                }
                boolean bl4 = keyAccess = isACLTypeCreate || this.keyManager.checkAccess((OzoneObj)objInfo, context);
                return keyAccess && this.prefixManager.checkAccess((OzoneObj)objInfo, parentContext) && this.bucketManager.checkAccess((OzoneObj)objInfo, parentContext) && this.volumeManager.checkAccess((OzoneObj)objInfo, parentVolContext);
            }
            case PREFIX: {
                boolean prefixAccess;
                LOG.trace("Checking access for Prefix: {}", (Object)objInfo);
                if (isOwner) {
                    return true;
                }
                boolean bl5 = prefixAccess = isACLTypeCreate || this.prefixManager.checkAccess((OzoneObj)objInfo, context);
                return prefixAccess && this.bucketManager.checkAccess((OzoneObj)objInfo, parentContext) && this.volumeManager.checkAccess((OzoneObj)objInfo, parentVolContext);
            }
        }
        throw new OMException("Unexpected object type:" + objInfo.getResourceType(), OMException.ResultCodes.INVALID_REQUEST);
    }

    @Override
    public OzoneNativeAuthorizer configure(OzoneManager om, KeyManager km, PrefixManager pm) {
        Objects.requireNonNull(om, "om == null");
        this.volumeManager = om.getVolumeManager();
        this.bucketManager = om.getBucketManager();
        this.allowListAllVolumes = om::getAllowListAllVolumes;
        this.setAdminCheck(om::isAdmin);
        this.setReadOnlyAdminCheck(om::isReadOnlyAdmin);
        this.keyManager = km;
        this.prefixManager = pm;
        return this;
    }

    public void setAdminCheck(Predicate<UserGroupInformation> check) {
        this.adminCheck = Objects.requireNonNull(check, "admin check");
    }

    public void setReadOnlyAdminCheck(Predicate<UserGroupInformation> check) {
        this.readOnlyAdminCheck = Objects.requireNonNull(check, "read-only admin check");
    }

    public boolean getAllowListAllVolumes() {
        return this.allowListAllVolumes.getAsBoolean();
    }

    private static boolean isOwner(UserGroupInformation ugi, String ownerName) {
        return ownerName != null && ownerName.equals(ugi.getShortUserName());
    }
}

