/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security.acl;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PrefixManager;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneManagerAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneNativeAuthorizer;
import org.apache.hadoop.ozone.security.acl.SharedTmpDirAuthorizer;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneAuthorizerFactory {
    static final Logger LOG = LoggerFactory.getLogger(OzoneAuthorizerFactory.class);

    private OzoneAuthorizerFactory() {
    }

    public static IAccessAuthorizer forOM(OzoneManager om) {
        return OzoneAuthorizerFactory.create(om, om.getKeyManager(), om.getPrefixManager(), "OM");
    }

    public static IAccessAuthorizer forSnapshot(OzoneManager om, KeyManager keyManager, PrefixManager prefixManager) {
        return om.getAccessAuthorizer().isNative() ? OzoneAuthorizerFactory.create(om, keyManager, prefixManager, "Snapshot") : om.getAccessAuthorizer();
    }

    private static IAccessAuthorizer create(OzoneManager om, KeyManager km, PrefixManager pm, String name) {
        IAccessAuthorizer authorizer = OzoneAuthorizerFactory.createImpl(om, km, pm);
        LOG.info("{}: Authorizer for {} is {}", new Object[]{om.getOMNodeId(), name, authorizer.getClass()});
        return authorizer;
    }

    private static IAccessAuthorizer createImpl(OzoneManager om, KeyManager km, PrefixManager pm) {
        if (!om.getAclsEnabled()) {
            return OzoneAccessAuthorizer.get();
        }
        OzoneConfiguration conf = om.getConfiguration();
        Class<? extends IAccessAuthorizer> clazz = OzoneAuthorizerFactory.authorizerClass((ConfigurationSource)conf);
        if (OzoneAccessAuthorizer.class == clazz) {
            return OzoneAccessAuthorizer.get();
        }
        if (OzoneNativeAuthorizer.class == clazz) {
            return new OzoneNativeAuthorizer().configure(om, km, pm);
        }
        IAccessAuthorizer authorizer = (IAccessAuthorizer)ReflectionUtils.newInstance(clazz, (Configuration)conf);
        if (authorizer instanceof OzoneManagerAuthorizer) {
            return ((OzoneManagerAuthorizer)authorizer).configure(om, km, pm);
        }
        if (conf.getBoolean("ozone.om.enable.ofs.shared.tmp.dir", false)) {
            return new SharedTmpDirAuthorizer(new OzoneNativeAuthorizer().configure(om, km, pm), authorizer);
        }
        return authorizer;
    }

    private static Class<? extends IAccessAuthorizer> authorizerClass(ConfigurationSource conf) {
        return conf.getClass("ozone.acl.authorizer.class", OzoneAccessAuthorizer.class, IAccessAuthorizer.class);
    }
}

