/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneSecretStore {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneSecretStore.class);
    private OMMetadataManager omMetadataManager;

    public OzoneSecretStore(OzoneConfiguration conf, OMMetadataManager omMetadataManager) {
        this.omMetadataManager = omMetadataManager;
    }

    public OzoneManagerSecretState loadState() throws IOException {
        OzoneManagerSecretState state = new OzoneManagerSecretState();
        int numTokens = this.loadTokens(state);
        LOG.info("Loaded {} tokens", (Object)numTokens);
        return state;
    }

    public void storeToken(OzoneTokenIdentifier tokenId, long renewDate) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Storing token {}", (Object)tokenId.getSequenceNumber());
        }
        try {
            this.omMetadataManager.getDelegationTokenTable().put((Object)tokenId, (Object)renewDate);
        }
        catch (IOException e) {
            LOG.error("Unable to store token " + tokenId.toString(), (Throwable)e);
            throw e;
        }
    }

    public void updateToken(OzoneTokenIdentifier tokenId, long renewDate) throws IOException {
        this.storeToken(tokenId, renewDate);
    }

    public void removeToken(OzoneTokenIdentifier tokenId) throws IOException {
        try {
            this.omMetadataManager.getDelegationTokenTable().delete((Object)tokenId);
        }
        catch (IOException e) {
            LOG.error("Unable to remove token {}", (Object)tokenId.toString(), (Object)e);
            throw e;
        }
    }

    public int loadTokens(OzoneManagerSecretState state) throws IOException {
        int loadedToken = 0;
        Throwable throwable = null;
        Object var4_5 = null;
        try (Table.KeyValueIterator iterator = this.omMetadataManager.getDelegationTokenTable().iterator();){
            iterator.seekToFirst();
            while (iterator.hasNext()) {
                Table.KeyValue kv = (Table.KeyValue)iterator.next();
                state.tokenState.put(kv.getKey(), kv.getValue());
                ++loadedToken;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return loadedToken;
    }

    public static class OzoneManagerSecretState<T> {
        private Map<T, Long> tokenState = new HashMap<T, Long>();

        public Map<T, Long> getTokenState() {
            return this.tokenState;
        }
    }
}

