/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security;

import java.io.IOException;
import java.security.KeyPair;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMSecurityProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.client.DefaultCertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateSignRequest;
import org.apache.hadoop.hdds.security.x509.exception.CertificateException;
import org.apache.hadoop.ozone.om.OMStorage;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMCertificateClient
extends DefaultCertificateClient {
    private static final Logger LOG = LoggerFactory.getLogger(OMCertificateClient.class);
    public static final String COMPONENT_NAME = "om";
    private String serviceId;
    private String scmID;
    private final String clusterID;
    private final HddsProtos.OzoneManagerDetailsProto omInfo;

    public OMCertificateClient(SecurityConfig secConfig, SCMSecurityProtocolClientSideTranslatorPB scmSecurityClient, OMStorage omStorage, HddsProtos.OzoneManagerDetailsProto omInfo, String serviceId, String scmID, Consumer<String> saveCertIdCallback, Runnable shutdownCallback) {
        super(secConfig, scmSecurityClient, LOG, omStorage.getOmCertSerialId(), COMPONENT_NAME, HddsUtils.threadNamePrefix((Object)omStorage.getOmNodeId()), saveCertIdCallback, shutdownCallback);
        this.serviceId = serviceId;
        this.scmID = scmID;
        this.clusterID = omStorage.getClusterID();
        this.omInfo = omInfo;
    }

    public CertificateSignRequest.Builder configureCSRBuilder() throws SCMSecurityException {
        String subject;
        CertificateSignRequest.Builder builder = super.configureCSRBuilder();
        String hostname = this.omInfo.getHostName();
        if (builder.hasDnsName()) {
            try {
                subject = String.valueOf(UserGroupInformation.getCurrentUser().getShortUserName()) + "@" + hostname;
            }
            catch (IOException e) {
                throw new CertificateException("Failed to getCurrentUser", (Throwable)e);
            }
        } else {
            subject = hostname;
        }
        builder.setCA(Boolean.valueOf(false)).setKey(new KeyPair(this.getPublicKey(), this.getPrivateKey())).setConfiguration(this.getSecurityConfig()).setScmID(this.scmID).setClusterID(this.clusterID).setSubject(subject);
        if (!StringUtils.isEmpty((CharSequence)this.serviceId)) {
            builder.addServiceName(this.serviceId);
        }
        LOG.info("Creating csr for OM->dns:{},ip:{},scmId:{},clusterId:{},subject:{}", new Object[]{hostname, this.omInfo.getIpAddress(), this.scmID, this.clusterID, subject});
        return builder;
    }

    protected SCMSecurityProtocolProtos.SCMGetCertResponseProto sign(CertificateSignRequest request) throws IOException {
        return this.getScmSecureClient().getOMCertChain(this.omInfo, request.toEncodedFormat());
    }

    public Logger getLogger() {
        return LOG;
    }
}

