/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.snapshot.filter;

import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.snapshot.filter.ReclaimableFilter;
import org.apache.ratis.util.function.UncheckedAutoCloseableSupplier;

public class ReclaimableDirFilter
extends ReclaimableFilter<OmKeyInfo> {
    public ReclaimableDirFilter(OzoneManager ozoneManager, OmSnapshotManager omSnapshotManager, SnapshotChainManager snapshotChainManager, SnapshotInfo currentSnapshotInfo, KeyManager keyManager, IOzoneManagerLock lock) {
        super(ozoneManager, omSnapshotManager, snapshotChainManager, currentSnapshotInfo, keyManager, lock, 1);
    }

    @Override
    protected String getVolumeName(Table.KeyValue<String, OmKeyInfo> keyValue) throws IOException {
        return ((OmKeyInfo)keyValue.getValue()).getVolumeName();
    }

    @Override
    protected String getBucketName(Table.KeyValue<String, OmKeyInfo> keyValue) throws IOException {
        return ((OmKeyInfo)keyValue.getValue()).getBucketName();
    }

    @Override
    protected Boolean isReclaimable(Table.KeyValue<String, OmKeyInfo> deletedDirInfo) throws IOException {
        UncheckedAutoCloseableSupplier<OmSnapshot> previousSnapshot = this.getPreviousOmSnapshot(0);
        KeyManager prevKeyManager = previousSnapshot == null ? null : ((OmSnapshot)previousSnapshot.get()).getKeyManager();
        return this.isDirReclaimable(this.getVolumeId(), this.getBucketInfo(), (OmKeyInfo)deletedDirInfo.getValue(), this.getKeyManager(), prevKeyManager);
    }

    private boolean isDirReclaimable(long volumeId, OmBucketInfo bucketInfo, OmKeyInfo dirInfo, KeyManager keyManager, KeyManager previousKeyManager) throws IOException {
        if (previousKeyManager == null) {
            return true;
        }
        OmDirectoryInfo prevDirectoryInfo = (OmDirectoryInfo)keyManager.getPreviousSnapshotOzoneDirInfo(volumeId, bucketInfo, dirInfo).apply((Object)previousKeyManager);
        return prevDirectoryInfo == null || prevDirectoryInfo.getObjectID() != dirInfo.getObjectID();
    }
}

