/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.snapshot;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OmSnapshotLocalData;
import org.apache.hadoop.ozone.om.OmSnapshotLocalDataYaml;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.util.ObjectSerializer;
import org.apache.hadoop.ozone.util.WithChecksum;
import org.apache.hadoop.ozone.util.YamlSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class OmSnapshotLocalDataManager
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(OmSnapshotLocalDataManager.class);
    private final ObjectSerializer<OmSnapshotLocalData> snapshotLocalDataSerializer;
    private final MutableGraph<LocalDataVersionNode> localDataGraph = GraphBuilder.directed().build();
    private final Map<UUID, SnapshotVersionsMeta> versionNodeMap;
    private final OMMetadataManager omMetadataManager;

    public OmSnapshotLocalDataManager(OMMetadataManager omMetadataManager) throws IOException {
        this.omMetadataManager = omMetadataManager;
        this.snapshotLocalDataSerializer = new YamlSerializer<OmSnapshotLocalData>((BasePooledObjectFactory)new OmSnapshotLocalDataYaml.YamlFactory()){

            public void computeAndSetChecksum(Yaml yaml, OmSnapshotLocalData data) throws IOException {
                data.computeAndSetChecksum(yaml);
            }
        };
        this.versionNodeMap = new HashMap<UUID, SnapshotVersionsMeta>();
        this.init();
    }

    @VisibleForTesting
    Map<UUID, SnapshotVersionsMeta> getVersionNodeMap() {
        return this.versionNodeMap;
    }

    public static String getSnapshotLocalPropertyYamlPath(Path snapshotPath) {
        return String.valueOf(snapshotPath.toString()) + ".yaml";
    }

    public String getSnapshotLocalPropertyYamlPath(SnapshotInfo snapshotInfo) {
        return this.getSnapshotLocalPropertyYamlPath(snapshotInfo.getSnapshotId());
    }

    public String getSnapshotLocalPropertyYamlPath(UUID snapshotId) {
        Path snapshotPath = OmSnapshotManager.getSnapshotPath(this.omMetadataManager, snapshotId);
        return OmSnapshotLocalDataManager.getSnapshotLocalPropertyYamlPath(snapshotPath);
    }

    public void createNewOmSnapshotLocalDataFile(RDBStore snapshotStore, SnapshotInfo snapshotInfo) throws IOException {
        Path snapshotLocalDataPath = Paths.get(OmSnapshotLocalDataManager.getSnapshotLocalPropertyYamlPath(snapshotStore.getDbLocation().toPath()), new String[0]);
        Files.deleteIfExists(snapshotLocalDataPath);
        OmSnapshotLocalData snapshotLocalDataYaml = new OmSnapshotLocalData(snapshotInfo.getSnapshotId(), OmSnapshotManager.getSnapshotSSTFileList(snapshotStore), snapshotInfo.getPathPreviousSnapshotId());
        this.snapshotLocalDataSerializer.save(snapshotLocalDataPath.toFile(), (WithChecksum)snapshotLocalDataYaml);
    }

    public OmSnapshotLocalData getOmSnapshotLocalData(SnapshotInfo snapshotInfo) throws IOException {
        return this.getOmSnapshotLocalData(snapshotInfo.getSnapshotId());
    }

    public OmSnapshotLocalData getOmSnapshotLocalData(UUID snapshotId) throws IOException {
        Path snapshotLocalDataPath = Paths.get(this.getSnapshotLocalPropertyYamlPath(snapshotId), new String[0]);
        OmSnapshotLocalData snapshotLocalData = (OmSnapshotLocalData)this.snapshotLocalDataSerializer.load(snapshotLocalDataPath.toFile());
        if (!Objects.equals(snapshotLocalData.getSnapshotId(), snapshotId)) {
            throw new IOException("SnapshotId in path : " + snapshotLocalDataPath + " contains snapshotLocalData " + "corresponding to snapshotId " + snapshotLocalData.getSnapshotId() + ". Expected snapshotId " + snapshotId);
        }
        return snapshotLocalData;
    }

    public OmSnapshotLocalData getOmSnapshotLocalData(File snapshotDataPath) throws IOException {
        return (OmSnapshotLocalData)this.snapshotLocalDataSerializer.load(snapshotDataPath);
    }

    private LocalDataVersionNode getVersionNode(UUID snapshotId, int version) {
        if (!this.versionNodeMap.containsKey(snapshotId)) {
            return null;
        }
        return this.versionNodeMap.get(snapshotId).getVersionNode(version);
    }

    private void addSnapshotVersionMeta(UUID snapshotId, SnapshotVersionsMeta snapshotVersionsMeta) throws IOException {
        if (!this.versionNodeMap.containsKey(snapshotId)) {
            for (LocalDataVersionNode versionNode : snapshotVersionsMeta.getSnapshotVersions().values()) {
                LocalDataVersionNode previousVersionNode;
                if (this.getVersionNode(versionNode.snapshotId, versionNode.version) != null) {
                    throw new IOException("Unable to add " + versionNode + " since it already exists");
                }
                LocalDataVersionNode localDataVersionNode = previousVersionNode = versionNode.previousSnapshotId == null ? null : this.getVersionNode(versionNode.previousSnapshotId, versionNode.previousSnapshotVersion);
                if (versionNode.previousSnapshotId != null && previousVersionNode == null) {
                    throw new IOException("Unable to add " + versionNode + " since previous snapshot with version hasn't been " + "loaded");
                }
                this.localDataGraph.addNode((Object)versionNode);
                if (previousVersionNode == null) continue;
                this.localDataGraph.putEdge((Object)versionNode, (Object)previousVersionNode);
            }
            this.versionNodeMap.put(snapshotId, snapshotVersionsMeta);
        }
    }

    void addVersionNodeWithDependents(OmSnapshotLocalData snapshotLocalData) throws IOException {
        if (this.versionNodeMap.containsKey(snapshotLocalData.getSnapshotId())) {
            return;
        }
        HashSet<UUID> visitedSnapshotIds = new HashSet<UUID>();
        Stack<Pair> stack = new Stack<Pair>();
        stack.push(Pair.of((Object)snapshotLocalData.getSnapshotId(), (Object)new SnapshotVersionsMeta(snapshotLocalData)));
        while (!stack.isEmpty()) {
            Pair versionNodeToProcess = (Pair)stack.peek();
            UUID snapId = (UUID)versionNodeToProcess.getLeft();
            SnapshotVersionsMeta snapshotVersionsMeta = (SnapshotVersionsMeta)versionNodeToProcess.getRight();
            if (visitedSnapshotIds.contains(snapId)) {
                this.addSnapshotVersionMeta(snapId, snapshotVersionsMeta);
                stack.pop();
                continue;
            }
            UUID prevSnapId = snapshotVersionsMeta.getPreviousSnapshotId();
            if (prevSnapId != null && !this.versionNodeMap.containsKey(prevSnapId)) {
                OmSnapshotLocalData prevSnapshotLocalData = this.getOmSnapshotLocalData(prevSnapId);
                stack.push(Pair.of((Object)prevSnapshotLocalData.getSnapshotId(), (Object)new SnapshotVersionsMeta(prevSnapshotLocalData)));
            }
            visitedSnapshotIds.add(snapId);
        }
    }

    private void init() throws IOException {
        RDBStore store = (RDBStore)this.omMetadataManager.getStore();
        String checkpointPrefix = store.getDbLocation().getName();
        File snapshotDir = new File(store.getSnapshotsParentDir());
        File[] localDataFiles = snapshotDir.listFiles((dir, name) -> name.startsWith(checkpointPrefix) && name.endsWith(".yaml"));
        if (localDataFiles == null) {
            throw new IOException("Error while listing yaml files inside directory: " + snapshotDir.getAbsolutePath());
        }
        Arrays.sort(localDataFiles, Comparator.comparing(File::getName));
        File[] fileArray = localDataFiles;
        int n = localDataFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String actualPath;
            File localDataFile = fileArray[n2];
            OmSnapshotLocalData snapshotLocalData = (OmSnapshotLocalData)this.snapshotLocalDataSerializer.load(localDataFile);
            File file = new File(this.getSnapshotLocalPropertyYamlPath(snapshotLocalData.getSnapshotId()));
            String expectedPath = file.getAbsolutePath();
            if (!expectedPath.equals(actualPath = localDataFile.getAbsolutePath())) {
                throw new IOException("Unexpected path for local data file with snapshotId:" + snapshotLocalData.getSnapshotId() + " : " + actualPath + ". " + "Expected: " + expectedPath);
            }
            this.addVersionNodeWithDependents(snapshotLocalData);
            ++n2;
        }
    }

    @Override
    public void close() {
        if (this.snapshotLocalDataSerializer != null) {
            try {
                this.snapshotLocalDataSerializer.close();
            }
            catch (IOException e) {
                LOG.error("Failed to close snapshot local data serializer", (Throwable)e);
            }
        }
    }

    static final class LocalDataVersionNode {
        private final UUID snapshotId;
        private final int version;
        private final UUID previousSnapshotId;
        private final int previousSnapshotVersion;

        private LocalDataVersionNode(UUID snapshotId, int version, UUID previousSnapshotId, int previousSnapshotVersion) {
            this.previousSnapshotId = previousSnapshotId;
            this.previousSnapshotVersion = previousSnapshotVersion;
            this.snapshotId = snapshotId;
            this.version = version;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LocalDataVersionNode)) {
                return false;
            }
            LocalDataVersionNode that = (LocalDataVersionNode)o;
            return this.version == that.version && this.previousSnapshotVersion == that.previousSnapshotVersion && this.snapshotId.equals(that.snapshotId) && Objects.equals(this.previousSnapshotId, that.previousSnapshotId);
        }

        public int hashCode() {
            return Objects.hash(this.snapshotId, this.version, this.previousSnapshotId, this.previousSnapshotVersion);
        }
    }

    static final class SnapshotVersionsMeta {
        private final UUID previousSnapshotId;
        private final Map<Integer, LocalDataVersionNode> snapshotVersions;
        private int version;

        private SnapshotVersionsMeta(OmSnapshotLocalData snapshotLocalData) {
            this.previousSnapshotId = snapshotLocalData.getPreviousSnapshotId();
            this.snapshotVersions = this.getVersionNodes(snapshotLocalData);
            this.version = snapshotLocalData.getVersion();
        }

        private Map<Integer, LocalDataVersionNode> getVersionNodes(OmSnapshotLocalData snapshotLocalData) {
            UUID snapshotId = snapshotLocalData.getSnapshotId();
            UUID prevSnapshotId = snapshotLocalData.getPreviousSnapshotId();
            HashMap<Integer, LocalDataVersionNode> versionNodes = new HashMap<Integer, LocalDataVersionNode>();
            for (Map.Entry<Integer, OmSnapshotLocalData.VersionMeta> entry : snapshotLocalData.getVersionSstFileInfos().entrySet()) {
                versionNodes.put(entry.getKey(), new LocalDataVersionNode(snapshotId, entry.getKey(), prevSnapshotId, entry.getValue().getPreviousSnapshotVersion()));
            }
            return versionNodes;
        }

        UUID getPreviousSnapshotId() {
            return this.previousSnapshotId;
        }

        int getVersion() {
            return this.version;
        }

        Map<Integer, LocalDataVersionNode> getSnapshotVersions() {
            return this.snapshotVersions;
        }

        LocalDataVersionNode getVersionNode(int snapshotVersion) {
            return this.snapshotVersions.get(snapshotVersion);
        }
    }
}

