/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.upgrade;

import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CleanupTableInfo(cleanupTables={"metaTable"})
public class OMFinalizeUpgradeResponse
extends OMClientResponse {
    private static final Logger LOG = LoggerFactory.getLogger(OMFinalizeUpgradeResponse.class);
    private int layoutVersionToWrite = -1;

    public OMFinalizeUpgradeResponse(OzoneManagerProtocolProtos.OMResponse omResponse, int layoutVersionToWrite) {
        super(omResponse);
        this.layoutVersionToWrite = layoutVersionToWrite;
    }

    @Override
    protected void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.layoutVersionToWrite != -1) {
            LOG.info("Layout version to persist to DB : {}", (Object)this.layoutVersionToWrite);
            omMetadataManager.getMetaTable().putWithBatch(batchOperation, (Object)"#LAYOUTVERSION", (Object)String.valueOf(this.layoutVersionToWrite));
        }
    }
}

