/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;

public abstract class OMVolumeRequest
extends OMClientRequest {
    public OMVolumeRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    protected OzoneManagerStorageProtos.PersistedUserVolumeInfo delVolumeFromOwnerList(OzoneManagerStorageProtos.PersistedUserVolumeInfo volumeList, String volume, String owner, long txID) throws IOException {
        ArrayList prevVolList = new ArrayList();
        if (volumeList == null) {
            throw new OMException("User not found: " + owner, OMException.ResultCodes.USER_NOT_FOUND);
        }
        prevVolList.addAll(volumeList.getVolumeNamesList());
        prevVolList.remove(volume);
        OzoneManagerStorageProtos.PersistedUserVolumeInfo newVolList = OzoneManagerStorageProtos.PersistedUserVolumeInfo.newBuilder().addAllVolumeNames(prevVolList).setObjectID(volumeList.getObjectID()).setUpdateID(txID).build();
        return newVolList;
    }

    protected static OzoneManagerStorageProtos.PersistedUserVolumeInfo addVolumeToOwnerList(OzoneManagerStorageProtos.PersistedUserVolumeInfo volumeList, String volume, String owner, long maxUserVolumeCount, long txID) throws IOException {
        if (volumeList != null && (long)volumeList.getVolumeNamesList().size() >= maxUserVolumeCount) {
            throw new OMException("Too many volumes for user:" + owner, OMException.ResultCodes.USER_TOO_MANY_VOLUMES);
        }
        HashSet<String> volumeSet = new HashSet<String>();
        long objectID = txID;
        if (volumeList != null) {
            volumeSet.addAll(volumeList.getVolumeNamesList());
            objectID = volumeList.getObjectID();
        }
        volumeSet.add(volume);
        return OzoneManagerStorageProtos.PersistedUserVolumeInfo.newBuilder().setObjectID(objectID).setUpdateID(txID).addAllVolumeNames(volumeSet).build();
    }

    protected static void createVolume(OMMetadataManager omMetadataManager, OmVolumeArgs omVolumeArgs, OzoneManagerStorageProtos.PersistedUserVolumeInfo volumeList, String dbVolumeKey, String dbUserKey, long transactionLogIndex) {
        omMetadataManager.getUserTable().addCacheEntry(new CacheKey((Object)dbUserKey), CacheValue.get((long)transactionLogIndex, (Object)volumeList));
        omMetadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)dbVolumeKey), CacheValue.get((long)transactionLogIndex, (Object)omVolumeArgs));
    }

    protected OmVolumeArgs getVolumeInfo(OMMetadataManager omMetadataManager, String volume) throws IOException {
        String dbVolumeKey = omMetadataManager.getVolumeKey(volume);
        OmVolumeArgs volumeArgs = (OmVolumeArgs)omMetadataManager.getVolumeTable().get((Object)dbVolumeKey);
        if (volumeArgs == null) {
            throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        return volumeArgs;
    }
}

