/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.snapshot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.OMSystemAction;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshotInternalMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.snapshot.OMSnapshotMoveUtils;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.snapshot.OMSnapshotMoveTableKeysResponse;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.DisallowedUntilLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OMSnapshotMoveTableKeysRequest
extends OMClientRequest {
    private static final AuditLogger AUDIT;
    private static final String AUDIT_PARAM_FROM_SNAPSHOT_TABLE_KEY = "fromSnapshotTableKey";
    private static final String AUDIT_PARAM_TO_SNAPSHOT_TABLE_KEY_OR_AOS = "toSnapshotTableKeyOrAOS";
    private static final String AUDIT_PARAM_DEL_KEYS_MOVED = "deletedKeysMoved";
    private static final String AUDIT_PARAM_RENAMED_KEYS_MOVED = "renamedKeysMoved";
    private static final String AUDIT_PARAM_DEL_DIRS_MOVED = "deletedDirsMoved";
    private static final String AUDIT_PARAM_DEL_KEYS_MOVED_LIST = "deletedKeysMovedList";
    private static final String AUDIT_PARAM_RENAMED_KEYS_LIST = "renamedKeysList";
    private static final String AUDIT_PARAM_DEL_DIRS_MOVED_LIST = "deletedDirsMovedList";
    private static final String AOS = "AOS";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        OMSnapshotMoveTableKeysRequest.ajc$preClinit();
        AUDIT = new AuditLogger(AuditLoggerType.OMSYSTEMLOGGER);
    }

    public OMSnapshotMoveTableKeysRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OmMetadataManagerImpl omMetadataManager = (OmMetadataManagerImpl)ozoneManager.getMetadataManager();
        SnapshotChainManager snapshotChainManager = omMetadataManager.getSnapshotChainManager();
        OzoneManagerProtocolProtos.SnapshotMoveTableKeysRequest moveTableKeysRequest = this.getOmRequest().getSnapshotMoveTableKeysRequest();
        UUID fromSnapshotID = HddsUtils.fromProtobuf((HddsProtos.UUID)moveTableKeysRequest.getFromSnapshotID());
        SnapshotInfo fromSnapshot = SnapshotUtils.getSnapshotInfo(ozoneManager, snapshotChainManager, fromSnapshotID);
        String bucketKeyPrefix = omMetadataManager.getBucketKeyPrefix(fromSnapshot.getVolumeName(), fromSnapshot.getBucketName());
        String bucketKeyPrefixFSO = omMetadataManager.getBucketKeyPrefixFSO(fromSnapshot.getVolumeName(), fromSnapshot.getBucketName());
        HashSet<String> keys = new HashSet<String>();
        ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> deletedKeys = new ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos>(moveTableKeysRequest.getDeletedKeysList().size());
        for (OzoneManagerProtocolProtos.SnapshotMoveKeyInfos deletedKey : moveTableKeysRequest.getDeletedKeysList()) {
            if (deletedKey.getKeyInfosList().isEmpty()) continue;
            deletedKeys.add(deletedKey);
            if (!deletedKey.getKey().startsWith(bucketKeyPrefix)) {
                OMException ex = new OMException("Deleted Key: " + deletedKey + " doesn't start with prefix " + bucketKeyPrefix, OMException.ResultCodes.INVALID_KEY_NAME);
                if (OMClientRequest.LOG.isDebugEnabled()) {
                    AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.SNAPSHOT_MOVE_TABLE_KEYS, null, ex));
                }
                throw ex;
            }
            if (keys.contains(deletedKey.getKey())) {
                OMException ex = new OMException("Duplicate Deleted Key: " + deletedKey + " in request", OMException.ResultCodes.INVALID_REQUEST);
                if (OMClientRequest.LOG.isDebugEnabled()) {
                    AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.SNAPSHOT_MOVE_TABLE_KEYS, null, ex));
                }
                throw ex;
            }
            keys.add(deletedKey.getKey());
        }
        keys.clear();
        ArrayList<HddsProtos.KeyValue> renamedKeysList = new ArrayList<HddsProtos.KeyValue>(moveTableKeysRequest.getRenamedKeysList().size());
        for (HddsProtos.KeyValue renamedKey : moveTableKeysRequest.getRenamedKeysList()) {
            if (!renamedKey.hasKey() || !renamedKey.hasValue()) continue;
            renamedKeysList.add(renamedKey);
            if (!renamedKey.getKey().startsWith(bucketKeyPrefix)) {
                OMException ex = new OMException("Rename Key: " + renamedKey + " doesn't start with prefix " + bucketKeyPrefix, OMException.ResultCodes.INVALID_KEY_NAME);
                if (OMClientRequest.LOG.isDebugEnabled()) {
                    AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.SNAPSHOT_MOVE_TABLE_KEYS, null, ex));
                }
                throw ex;
            }
            if (keys.contains(renamedKey.getKey())) {
                OMException ex = new OMException("Duplicate rename Key: " + renamedKey + " in request", OMException.ResultCodes.INVALID_REQUEST);
                if (OMClientRequest.LOG.isDebugEnabled()) {
                    AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.SNAPSHOT_MOVE_TABLE_KEYS, null, ex));
                }
                throw ex;
            }
            keys.add(renamedKey.getKey());
        }
        keys.clear();
        ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos> deletedDirs = new ArrayList<OzoneManagerProtocolProtos.SnapshotMoveKeyInfos>(moveTableKeysRequest.getDeletedDirsList().size());
        for (OzoneManagerProtocolProtos.SnapshotMoveKeyInfos deletedDir : moveTableKeysRequest.getDeletedDirsList()) {
            if (deletedDir.getKeyInfosList().size() != 1) continue;
            deletedDirs.add(deletedDir);
            if (!deletedDir.getKey().startsWith(bucketKeyPrefixFSO)) {
                OMException ex = new OMException("Deleted dir: " + deletedDir + " doesn't start with prefix " + bucketKeyPrefixFSO, OMException.ResultCodes.INVALID_KEY_NAME);
                if (OMClientRequest.LOG.isDebugEnabled()) {
                    AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.SNAPSHOT_MOVE_TABLE_KEYS, null, ex));
                }
                throw ex;
            }
            if (keys.contains(deletedDir.getKey())) {
                OMException ex = new OMException("Duplicate deleted dir Key: " + deletedDir + " in request", OMException.ResultCodes.INVALID_REQUEST);
                if (OMClientRequest.LOG.isDebugEnabled()) {
                    AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.SNAPSHOT_MOVE_TABLE_KEYS, null, ex));
                }
                throw ex;
            }
            keys.add(deletedDir.getKey());
        }
        return this.getOmRequest().toBuilder().setSnapshotMoveTableKeysRequest(moveTableKeysRequest.toBuilder().clearDeletedDirs().clearDeletedKeys().clearRenamedKeys().addAllDeletedKeys(deletedKeys).addAllDeletedDirs(deletedDirs).addAllRenamedKeys(renamedKeysList).build()).build();
    }

    @Override
    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.FILESYSTEM_SNAPSHOT)
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMSnapshotMoveTableKeysResponse omClientResponse;
        block10: {
            OzoneManager ozoneManager2 = ozoneManager;
            ExecutionContext executionContext = context;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)ozoneManager2, (Object)executionContext);
            OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
            OmSnapshotInternalMetrics omSnapshotIntMetrics = ozoneManager.getOmSnapshotIntMetrics();
            OmMetadataManagerImpl omMetadataManager = (OmMetadataManagerImpl)ozoneManager.getMetadataManager();
            SnapshotChainManager snapshotChainManager = omMetadataManager.getSnapshotChainManager();
            OzoneManagerProtocolProtos.SnapshotMoveTableKeysRequest moveTableKeysRequest = this.getOmRequest().getSnapshotMoveTableKeysRequest();
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            UUID fromSnapshotID = HddsUtils.fromProtobuf((HddsProtos.UUID)moveTableKeysRequest.getFromSnapshotID());
            try {
                SnapshotInfo fromSnapshot = SnapshotUtils.getSnapshotInfo(ozoneManager, snapshotChainManager, HddsUtils.fromProtobuf((HddsProtos.UUID)moveTableKeysRequest.getFromSnapshotID()));
                OmBucketInfo omBucketInfo = OMKeyRequest.getBucketInfo(omMetadataManager, fromSnapshot.getVolumeName(), fromSnapshot.getBucketName());
                SnapshotInfo nextSnapshot = SnapshotUtils.getNextSnapshot(ozoneManager, snapshotChainManager, fromSnapshot);
                if (nextSnapshot != null && nextSnapshot.getSnapshotStatus() != SnapshotInfo.SnapshotStatus.SNAPSHOT_ACTIVE) {
                    OMException ex = new OMException("Next snapshot : " + nextSnapshot + " in chain is not active.", OMException.ResultCodes.INVALID_SNAPSHOT_ERROR);
                    if (OMClientRequest.LOG.isDebugEnabled()) {
                        AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.SNAPSHOT_MOVE_TABLE_KEYS, null, ex));
                    }
                    throw ex;
                }
                List deletedKeysList = moveTableKeysRequest.getDeletedKeysList();
                List deletedDirsList = moveTableKeysRequest.getDeletedDirsList();
                List renamedKeysList = moveTableKeysRequest.getRenamedKeysList();
                OMSnapshotMoveUtils.updateCache(ozoneManager, fromSnapshot, nextSnapshot, context);
                omClientResponse = new OMSnapshotMoveTableKeysResponse(omResponse.build(), fromSnapshot, nextSnapshot, omBucketInfo.getObjectID(), moveTableKeysRequest.getDeletedKeysList(), moveTableKeysRequest.getDeletedDirsList(), moveTableKeysRequest.getRenamedKeysList());
                omSnapshotIntMetrics.incNumSnapshotMoveTableKeys();
                if (OMClientRequest.LOG.isDebugEnabled()) {
                    LinkedHashMap<String, String> auditParams = new LinkedHashMap<String, String>();
                    auditParams.put(AUDIT_PARAM_FROM_SNAPSHOT_TABLE_KEY, snapshotChainManager.getTableKey(fromSnapshotID));
                    if (nextSnapshot != null) {
                        auditParams.put(AUDIT_PARAM_TO_SNAPSHOT_TABLE_KEY_OR_AOS, nextSnapshot.getTableKey());
                    } else {
                        auditParams.put(AUDIT_PARAM_TO_SNAPSHOT_TABLE_KEY_OR_AOS, AOS);
                    }
                    auditParams.put(AUDIT_PARAM_DEL_KEYS_MOVED, String.valueOf(deletedKeysList.size()));
                    auditParams.put(AUDIT_PARAM_DEL_DIRS_MOVED, String.valueOf(deletedDirsList.size()));
                    auditParams.put(AUDIT_PARAM_RENAMED_KEYS_MOVED, String.valueOf(renamedKeysList.size()));
                    if (!deletedKeysList.isEmpty()) {
                        auditParams.put(AUDIT_PARAM_DEL_KEYS_MOVED_LIST, deletedKeysList.stream().map(OzoneManagerProtocolProtos.SnapshotMoveKeyInfos::getKey).collect(Collectors.joining(",")));
                    }
                    if (!deletedDirsList.isEmpty()) {
                        auditParams.put(AUDIT_PARAM_DEL_DIRS_MOVED_LIST, deletedDirsList.stream().map(OzoneManagerProtocolProtos.SnapshotMoveKeyInfos::getKey).collect(Collectors.joining(",")));
                    }
                    if (!renamedKeysList.isEmpty()) {
                        auditParams.put(AUDIT_PARAM_RENAMED_KEYS_LIST, renamedKeysList.toString());
                    }
                    AUDIT.logWriteSuccess(ozoneManager.buildAuditMessageForSuccess(OMSystemAction.SNAPSHOT_MOVE_TABLE_KEYS, auditParams));
                }
            }
            catch (IOException ex) {
                omClientResponse = new OMSnapshotMoveTableKeysResponse(this.createErrorOMResponse(omResponse, ex));
                omSnapshotIntMetrics.incNumSnapshotMoveTableKeysFails();
                if (!OMClientRequest.LOG.isDebugEnabled()) break block10;
                AUDIT.logWriteFailure(ozoneManager.buildAuditMessageForFailure(OMSystemAction.SNAPSHOT_MOVE_TABLE_KEYS, null, ex));
            }
        }
        return omClientResponse;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMSnapshotMoveTableKeysRequest.java", OMSnapshotMoveTableKeysRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.snapshot.OMSnapshotMoveTableKeysRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 76);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "validateAndUpdateCache", "org.apache.hadoop.ozone.om.request.snapshot.OMSnapshotMoveTableKeysRequest", "org.apache.hadoop.ozone.om.OzoneManager:org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext", "ozoneManager:context", "", "org.apache.hadoop.ozone.om.response.OMClientResponse"), 186);
    }
}

