/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.LinkedHashMap;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeySetTimesRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeySetTimesResponseWithFSO;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class OMKeySetTimesRequestWithFSO
extends OMKeySetTimesRequest {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        return super.preExecute(ozoneManager);
    }

    public OMKeySetTimesRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omReq, BucketLayout bucketLayout) {
        super(omReq, bucketLayout);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMClientRequest.Result result;
        Exception exception;
        OMClientResponse omClientResponse;
        block15: {
            long trxnLogIndex = context.getIndex();
            OmKeyInfo omKeyInfo = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = this.onInit();
            omClientResponse = null;
            exception = null;
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean lockAcquired = false;
            String volume = null;
            String bucket = null;
            String key = null;
            boolean operationResult = false;
            result = null;
            try {
                try {
                    volume = this.getVolumeName();
                    bucket = this.getBucketName();
                    key = this.getKeyName();
                    if (ozoneManager.getAclsEnabled()) {
                        this.checkAcls(ozoneManager, OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, bucket, key);
                    }
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volume, bucket}));
                    lockAcquired = this.getOmLockDetails().isLockAcquired();
                    OzoneFileStatus keyStatus = OMFileRequest.getOMKeyInfoIfExists(omMetadataManager, volume, bucket, key, 0L, ozoneManager.getDefaultReplicationConfig());
                    if (keyStatus == null) {
                        throw new OMException("Key not found. Key:" + key, OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    omKeyInfo = keyStatus.getKeyInfo();
                    omKeyInfo.setKeyName(OzoneFSUtils.getFileName((String)key));
                    long volumeId = omMetadataManager.getVolumeId(volume);
                    long bucketId = omMetadataManager.getBucketId(volume, bucket);
                    String dbKey = omMetadataManager.getOzonePathKey(volumeId, bucketId, omKeyInfo.getParentObjectID(), omKeyInfo.getFileName());
                    boolean isDirectory = keyStatus.isDirectory();
                    operationResult = true;
                    this.apply(omKeyInfo);
                    omKeyInfo.setUpdateID(trxnLogIndex);
                    if (isDirectory) {
                        Table dirTable = omMetadataManager.getDirectoryTable();
                        dirTable.addCacheEntry(new CacheKey((Object)dbKey), CacheValue.get((long)trxnLogIndex, (Object)OMFileRequest.getDirectoryInfo(omKeyInfo)));
                    } else {
                        omMetadataManager.getKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)dbKey), CacheValue.get((long)trxnLogIndex, (Object)omKeyInfo));
                    }
                    omClientResponse = this.onSuccess(omResponse, omKeyInfo, operationResult, isDirectory, volumeId, bucketId);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException | InvalidPathException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = this.onFailure(omResponse, exception);
                    if (lockAcquired) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volume, bucket}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (lockAcquired) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volume, bucket}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (lockAcquired) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volume, bucket}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        this.onComplete(result, exception, ozoneManager.getAuditLogger(), auditMap);
        return omClientResponse;
    }

    @Override
    protected OzoneManagerProtocolProtos.OMResponse.Builder onInit() {
        return OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
    }

    private OMClientResponse onSuccess(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, OmKeyInfo omKeyInfo, boolean operationResult, boolean isDir, long volumeId, long bucketId) {
        omResponse.setSuccess(operationResult);
        omResponse.setSetTimesResponse(OzoneManagerProtocolProtos.SetTimesResponse.newBuilder());
        return new OMKeySetTimesResponseWithFSO(omResponse.build(), omKeyInfo, isDir, this.getBucketLayout(), volumeId, bucketId);
    }

    @Override
    protected OMClientResponse onFailure(OzoneManagerProtocolProtos.OMResponse.Builder omResponse, Exception exception) {
        return new OMKeySetTimesResponseWithFSO(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
    }

    static {
        OMKeySetTimesRequestWithFSO.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMKeySetTimesRequestWithFSO.java", OMKeySetTimesRequestWithFSO.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.key.OMKeySetTimesRequestWithFSO", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 54);
    }
}

