/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.multitenant;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.multitenant.AuthorizerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizerLockImpl
implements AuthorizerLock {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizerLockImpl.class);
    private final StampedLock authorizerStampedLock = new StampedLock();
    private long omRequestWriteLockStamp = 0L;
    private long omRequestWriteLockHolderTid = 0L;

    @Override
    public long tryReadLock(long timeout) throws InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Trying to acquire authorizer read lock from thread {}", (Object)Thread.currentThread().getId());
        }
        return this.authorizerStampedLock.tryReadLock(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void unlockRead(long stamp) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Releasing authorizer read lock from thread {} with stamp {}", (Object)Thread.currentThread().getId(), (Object)stamp);
        }
        this.authorizerStampedLock.unlockRead(stamp);
    }

    @Override
    public long tryOptimisticReadThrowOnTimeout() throws IOException {
        long stamp;
        try {
            stamp = this.tryReadLock(1000L);
        }
        catch (InterruptedException e) {
            throw new OMException((Throwable)e, OMException.ResultCodes.INTERNAL_ERROR);
        }
        if (stamp == 0L) {
            throw new OMException("Timed out acquiring authorizer read lock. Another multi-tenancy request is in-progress. Try again later", OMException.ResultCodes.TIMEOUT);
        }
        long optimisticStamp = this.authorizerStampedLock.tryConvertToOptimisticRead(stamp);
        if (optimisticStamp == 0L) {
            this.unlockRead(stamp);
            throw new OMException("Failed to convert read lock to optimistic read.", OMException.ResultCodes.INTERNAL_ERROR);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Acquired authorizer optimistic read from thread {} with stamp {}", (Object)Thread.currentThread().getId(), (Object)optimisticStamp);
        }
        return optimisticStamp;
    }

    @Override
    public boolean validateOptimisticRead(long stamp) {
        return this.authorizerStampedLock.validate(stamp);
    }

    @Override
    public long tryWriteLock(long timeout) throws InterruptedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Trying to acquire authorizer write lock from thread {}", (Object)Thread.currentThread().getId());
        }
        return this.authorizerStampedLock.tryWriteLock(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void unlockWrite(long stamp) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Releasing authorizer write lock from thread {} with stamp {}", (Object)Thread.currentThread().getId(), (Object)stamp);
        }
        this.authorizerStampedLock.unlockWrite(stamp);
    }

    @Override
    public long tryWriteLockThrowOnTimeout() throws IOException {
        long stamp;
        try {
            stamp = this.tryWriteLock(1000L);
        }
        catch (InterruptedException e) {
            throw new OMException((Throwable)e, OMException.ResultCodes.INTERNAL_ERROR);
        }
        if (stamp == 0L) {
            throw new OMException("Timed out acquiring authorizer write lock. Another multi-tenancy request is in-progress. Try again later", OMException.ResultCodes.TIMEOUT);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Acquired authorizer write lock from thread {} with stamp {}", (Object)Thread.currentThread().getId(), (Object)stamp);
        }
        return stamp;
    }

    @Override
    public void tryWriteLockInOMRequest() throws IOException {
        long stamp = this.tryWriteLockThrowOnTimeout();
        Preconditions.checkArgument((this.omRequestWriteLockStamp == 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.omRequestWriteLockHolderTid == 0L ? 1 : 0) != 0);
        this.omRequestWriteLockStamp = stamp;
        this.omRequestWriteLockHolderTid = Thread.currentThread().getId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set omRequestWriteLockStamp to {}, omRequestWriteLockHolderTid to {}", (Object)this.omRequestWriteLockStamp, (Object)this.omRequestWriteLockHolderTid);
        }
    }

    @Override
    public void unlockWriteInOMRequest() {
        if (this.omRequestWriteLockStamp == 0L) {
            LOG.debug("Authorizer write lock is not held in this lock instance. This OM might be follower, or leader changed. Ignored");
            return;
        }
        long stamp = this.omRequestWriteLockStamp;
        this.omRequestWriteLockStamp = 0L;
        this.omRequestWriteLockHolderTid = 0L;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Restored omRequestWriteLockStamp to {}, omRequestWriteLockHolderTid to {}", (Object)this.omRequestWriteLockStamp, (Object)this.omRequestWriteLockHolderTid);
        }
        this.unlockWrite(stamp);
    }

    @Override
    public boolean isWriteLockHeldByCurrentThread() {
        if (this.omRequestWriteLockHolderTid == 0L) {
            LOG.debug("Write lock is not held by any OMRequest thread");
            return false;
        }
        if (this.omRequestWriteLockHolderTid != Thread.currentThread().getId()) {
            LOG.debug("Write lock is not held by current thread");
            return false;
        }
        return true;
    }
}

