/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.io.IOException;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;

public final class OmFSOFile {
    private String volumeName;
    private String bucketName;
    private String keyName;
    private OMMetadataManager omMetadataManager;
    private String fileName;
    private long volumeId;
    private long bucketId;
    private long parentID;

    private OmFSOFile(String volumeName, String bucketName, String keyName, OMMetadataManager omMetadataManager, String fileName, long volumeId, long bucketId, long parentID) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.keyName = keyName;
        this.omMetadataManager = omMetadataManager;
        this.fileName = fileName;
        this.volumeId = volumeId;
        this.bucketId = bucketId;
        this.parentID = parentID;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public OMMetadataManager getOmMetadataManager() {
        return this.omMetadataManager;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getVolumeId() {
        return this.volumeId;
    }

    public long getBucketId() {
        return this.bucketId;
    }

    public long getParentID() {
        return this.parentID;
    }

    public String getOpenFileName(long clientID) {
        return this.omMetadataManager.getOpenFileName(this.volumeId, this.bucketId, this.parentID, this.fileName, clientID);
    }

    public String getOzonePathKey() {
        return this.omMetadataManager.getOzonePathKey(this.volumeId, this.bucketId, this.parentID, this.fileName);
    }

    /* synthetic */ OmFSOFile(String string, String string2, String string3, OMMetadataManager oMMetadataManager, String string4, long l, long l2, long l3, OmFSOFile omFSOFile) {
        this(string, string2, string3, oMMetadataManager, string4, l, l2, l3);
    }

    public static class Builder {
        private String volumeName;
        private String bucketName;
        private String keyName;
        private OMMetadataManager omMetadataManager;
        private String errMsg = null;

        public Builder setVolumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public Builder setBucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder setKeyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public Builder setOmMetadataManager(OMMetadataManager omMetadataManager) {
            this.omMetadataManager = omMetadataManager;
            return this;
        }

        public Builder setErrMsg(String errMsg) {
            this.errMsg = errMsg;
            return this;
        }

        public OmFSOFile build() throws IOException {
            String fileName = OzoneFSUtils.getFileName((String)this.keyName);
            long volumeId = this.omMetadataManager.getVolumeId(this.volumeName);
            long bucketId = this.omMetadataManager.getBucketId(this.volumeName, this.bucketName);
            long parentID = OMFileRequest.getParentID(volumeId, bucketId, this.keyName, this.omMetadataManager, this.errMsg);
            return new OmFSOFile(this.volumeName, this.bucketName, this.keyName, this.omMetadataManager, fileName, volumeId, bucketId, parentID, null);
        }
    }
}

