/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.OFSPath;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.apache.ratis.protocol.ClientId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrashOzoneFileSystem
extends FileSystem {
    private static final int OZONE_FS_ITERATE_BATCH_SIZE = 100;
    private static final int OZONE_MAX_LIST_KEYS_SIZE = 10000;
    private final OzoneManager ozoneManager;
    private final AtomicLong runCount;
    private static final ClientId CLIENT_ID = ClientId.randomId();
    private static final Logger LOG = LoggerFactory.getLogger(TrashOzoneFileSystem.class);
    private final OzoneConfiguration ozoneConfiguration;

    public TrashOzoneFileSystem(OzoneManager ozoneManager) throws IOException {
        this.ozoneManager = ozoneManager;
        this.runCount = new AtomicLong(0L);
        this.setConf((Configuration)ozoneManager.getConfiguration());
        this.ozoneConfiguration = OzoneConfiguration.of((Configuration)this.getConf());
    }

    private void submitRequest(OzoneManagerProtocolProtos.OMRequest omRequest) throws Exception {
        this.ozoneManager.getMetrics().incNumTrashWriteRequests();
        OMClientRequest omClientRequest = OzoneManagerRatisUtils.createClientRequest(omRequest, this.ozoneManager);
        omRequest = omClientRequest.preExecute(this.ozoneManager);
        OzoneManagerRatisUtils.submitRequest(this.ozoneManager, omRequest, CLIENT_ID, this.runCount.getAndIncrement());
    }

    public URI getUri() {
        return URI.create("o3trash:///");
    }

    public FSDataInputStream open(Path path, int i) {
        throw new UnsupportedOperationException("fs.open() not implemented in TrashOzoneFileSystem");
    }

    public FSDataOutputStream create(Path path, FsPermission fsPermission, boolean b, int i, short i1, long l, Progressable progressable) {
        throw new UnsupportedOperationException("fs.create() not implemented in TrashOzoneFileSystem");
    }

    public FSDataOutputStream append(Path path, int i, Progressable progressable) {
        throw new UnsupportedOperationException("fs.append() not implemented in TrashOzoneFileSystem");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        this.ozoneManager.getMetrics().incNumTrashRenames();
        LOG.trace("Src:" + src + "Dst:" + dst);
        OFSPath srcPath = new OFSPath(src, this.ozoneConfiguration);
        OFSPath dstPath = new OFSPath(dst, this.ozoneConfiguration);
        OmBucketInfo bucket = this.ozoneManager.getBucketInfo(srcPath.getVolumeName(), srcPath.getBucketName());
        if (bucket.getBucketLayout().isFileSystemOptimized()) {
            return this.renameFSO(srcPath, dstPath);
        }
        Preconditions.checkArgument((boolean)srcPath.getBucketName().equals(dstPath.getBucketName()));
        Preconditions.checkArgument((boolean)srcPath.getTrashRoot().toString().equals(dstPath.getTrashRoot().toString()));
        RenameIterator iterator = new RenameIterator(src, dst);
        iterator.iterate();
        return true;
    }

    private boolean renameFSO(OFSPath srcPath, OFSPath dstPath) {
        this.ozoneManager.getMetrics().incNumTrashAtomicDirRenames();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.getRenameKeyRequest(srcPath, dstPath);
        try {
            if (omRequest != null) {
                this.submitRequest(omRequest);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOG.error("Couldn't send rename request", (Throwable)e);
            return false;
        }
    }

    public boolean delete(Path path, boolean b) throws IOException {
        this.ozoneManager.getMetrics().incNumTrashDeletes();
        OFSPath srcPath = new OFSPath(path, this.ozoneConfiguration);
        OmBucketInfo bucket = this.ozoneManager.getBucketInfo(srcPath.getVolumeName(), srcPath.getBucketName());
        if (bucket.getBucketLayout().isFileSystemOptimized()) {
            return this.deleteFSO(srcPath);
        }
        DeleteIterator iterator = new DeleteIterator(path, true);
        iterator.iterate();
        return true;
    }

    private boolean deleteFSO(OFSPath srcPath) {
        this.ozoneManager.getMetrics().incNumTrashAtomicDirDeletes();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.getDeleteKeyRequest(srcPath);
        try {
            if (omRequest != null) {
                this.submitRequest(omRequest);
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            LOG.error("Couldn't send delete request.", e);
            return false;
        }
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        this.ozoneManager.getMetrics().incNumTrashListStatus();
        ArrayList<FileStatus> fileStatuses = new ArrayList<FileStatus>();
        OmKeyArgs keyArgs = this.constructOmKeyArgs(path);
        List<OzoneFileStatus> list = this.ozoneManager.listStatus(keyArgs, false, null, Integer.MAX_VALUE);
        for (OzoneFileStatus status : list) {
            FileStatus fileStatus = this.convertToFileStatus(status);
            fileStatuses.add(fileStatus);
        }
        return fileStatuses.toArray(new FileStatus[0]);
    }

    private FileStatus convertToFileStatus(OzoneFileStatus status) {
        Path temp = new Path("/" + status.getKeyInfo().getVolumeName() + "/" + status.getKeyInfo().getBucketName() + "/" + status.getKeyInfo().getKeyName());
        return new FileStatus(status.getKeyInfo().getDataSize(), status.isDirectory(), status.getKeyInfo().getReplicationConfig().getRequiredNodes(), status.getBlockSize(), status.getKeyInfo().getModificationTime(), temp);
    }

    public void setWorkingDirectory(Path path) {
        throw new UnsupportedOperationException("fs.setWorkingDirectory() not implemented in TrashOzoneFileSystem");
    }

    public Path getWorkingDirectory() {
        throw new UnsupportedOperationException("fs.getWorkingDirectory() not implemented in TrashOzoneFileSystem");
    }

    public boolean mkdirs(Path path, FsPermission fsPermission) {
        throw new UnsupportedOperationException("fs.mkdirs() not implemented in TrashOzoneFileSystem");
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        this.ozoneManager.getMetrics().incNumGetFileStatus();
        OmKeyArgs keyArgs = this.constructOmKeyArgs(path);
        OzoneFileStatus ofs = this.ozoneManager.getKeyManager().getFileStatus(keyArgs);
        FileStatus fileStatus = this.convertToFileStatus(ofs);
        return fileStatus;
    }

    private OmKeyArgs constructOmKeyArgs(Path path) {
        OFSPath ofsPath = new OFSPath(path, this.ozoneConfiguration);
        String volume = ofsPath.getVolumeName();
        String bucket = ofsPath.getBucketName();
        String key = ofsPath.getKeyName();
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volume).setBucketName(bucket).setKeyName(key).setHeadOp(true).build();
        return keyArgs;
    }

    public Collection<FileStatus> getTrashRoots(boolean allUsers) {
        Preconditions.checkArgument((boolean)allUsers);
        this.ozoneManager.getMetrics().incNumTrashGetTrashRoots();
        Iterator bucketIterator = this.ozoneManager.getMetadataManager().getBucketIterator();
        ArrayList<FileStatus> ret = new ArrayList<FileStatus>();
        while (bucketIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)bucketIterator.next();
            OmBucketInfo omBucketInfo = (OmBucketInfo)((CacheValue)entry.getValue()).getCacheValue();
            if (omBucketInfo == null) continue;
            Path volumePath = new Path("/", omBucketInfo.getVolumeName());
            Path bucketPath = new Path(volumePath, omBucketInfo.getBucketName());
            Path trashRoot = new Path(bucketPath, ".Trash");
            try {
                FileStatus[] list;
                if (!this.exists(trashRoot)) continue;
                FileStatus[] fileStatusArray = list = this.listStatus(trashRoot);
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    FileStatus candidate = fileStatusArray[n2];
                    if (this.exists(candidate.getPath()) && candidate.isDirectory()) {
                        ret.add(candidate);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                LOG.error("Couldn't perform fs operation fs.listStatus()/fs.exists()", (Throwable)e);
            }
        }
        return ret;
    }

    public boolean exists(Path f) throws IOException {
        this.ozoneManager.getMetrics().incNumTrashExists();
        try {
            this.getFileStatus(f);
            return true;
        }
        catch (OMException e) {
            if (e.getResult() == OMException.ResultCodes.FILE_NOT_FOUND) {
                LOG.trace("Couldn't execute getFileStatus()", (Throwable)e);
                return false;
            }
            throw e;
        }
    }

    private OzoneManagerProtocolProtos.OMRequest.Builder createOMRequest(OzoneManagerProtocolProtos.Type cmdType) throws IOException {
        return OzoneManagerProtocolProtos.OMRequest.newBuilder().setClientId(CLIENT_ID.toString()).setVersion(ClientVersion.CURRENT_VERSION).setUserInfo(this.getUserInfo()).setCmdType(cmdType);
    }

    private OzoneManagerProtocolProtos.OMRequest getRenameKeyRequest(OFSPath src, OFSPath dst) {
        String volumeName = src.getVolumeName();
        String bucketName = src.getBucketName();
        String keyName = src.getKeyName();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setKeyName(keyName).setVolumeName(volumeName).setBucketName(bucketName).build();
        String toKeyName = dst.getKeyName();
        OzoneManagerProtocolProtos.RenameKeyRequest renameKeyRequest = OzoneManagerProtocolProtos.RenameKeyRequest.newBuilder().setKeyArgs(keyArgs).setToKeyName(toKeyName).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = null;
        try {
            omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.RenameKey).setRenameKeyRequest(renameKeyRequest).build();
        }
        catch (IOException e) {
            LOG.error("Couldn't get userinfo", (Throwable)e);
        }
        return omRequest;
    }

    private OzoneManagerProtocolProtos.OMRequest getDeleteKeyRequest(OFSPath srcPath) {
        String volume = srcPath.getVolumeName();
        String bucket = srcPath.getBucketName();
        String key = srcPath.getKeyName();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setKeyName(key).setVolumeName(volume).setBucketName(bucket).setRecursive(true).build();
        OzoneManagerProtocolProtos.DeleteKeyRequest deleteKeyRequest = OzoneManagerProtocolProtos.DeleteKeyRequest.newBuilder().setKeyArgs(keyArgs).build();
        OzoneManagerProtocolProtos.OMRequest omRequest = null;
        try {
            omRequest = this.createOMRequest(OzoneManagerProtocolProtos.Type.DeleteKey).setDeleteKeyRequest(deleteKeyRequest).build();
        }
        catch (IOException e) {
            LOG.error("Couldn't get userinfo", (Throwable)e);
        }
        return omRequest;
    }

    OzoneManagerProtocolProtos.UserInfo getUserInfo() throws IOException {
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        InetAddress remoteAddress = this.ozoneManager.getOmRpcServerAddr().getAddress();
        OzoneManagerProtocolProtos.UserInfo.Builder userInfo = OzoneManagerProtocolProtos.UserInfo.newBuilder();
        if (user != null) {
            userInfo.setUserName(user.getUserName());
        }
        if (remoteAddress != null) {
            userInfo.setHostName(remoteAddress.getHostName());
            userInfo.setRemoteAddress(remoteAddress.getHostAddress());
        }
        return userInfo.build();
    }

    private class DeleteIterator
    extends OzoneListingIterator {
        private final boolean recursive;
        private List<String> keysList;

        DeleteIterator(Path f, boolean recursive) throws IOException {
            super(f);
            this.recursive = recursive;
            this.keysList = new ArrayList<String>();
            if (this.getStatus().isDirectory() && !this.recursive && TrashOzoneFileSystem.this.listStatus(f).length != 0) {
                throw new PathIsNotEmptyDirectoryException(f.toString());
            }
        }

        @Override
        boolean processKeyPath(List<String> keyPathList) {
            LOG.trace("Deleting keys: {}", keyPathList);
            for (String keyPath : keyPathList) {
                OFSPath path = new OFSPath(keyPath, TrashOzoneFileSystem.this.ozoneConfiguration);
                OzoneManagerProtocolProtos.OMRequest omRequest = this.getDeleteKeysRequest(path);
                try {
                    TrashOzoneFileSystem.this.ozoneManager.getMetrics().incNumTrashFilesDeletes();
                    TrashOzoneFileSystem.this.submitRequest(omRequest);
                }
                catch (Throwable e) {
                    LOG.error("Couldn't send rename request.", e);
                }
            }
            return true;
        }

        private OzoneManagerProtocolProtos.OMRequest getDeleteKeysRequest(OFSPath keyPath) {
            String volumeName = keyPath.getVolumeName();
            String bucketName = keyPath.getBucketName();
            String keyName = keyPath.getKeyName();
            this.keysList.clear();
            this.keysList.add(keyName);
            OzoneManagerProtocolProtos.DeleteKeyArgs.Builder deleteKeyArgs = OzoneManagerProtocolProtos.DeleteKeyArgs.newBuilder().setBucketName(bucketName).setVolumeName(volumeName);
            deleteKeyArgs.addAllKeys(this.keysList);
            OzoneManagerProtocolProtos.DeleteKeysRequest deleteKeysRequest = OzoneManagerProtocolProtos.DeleteKeysRequest.newBuilder().setDeleteKeys(deleteKeyArgs).build();
            OzoneManagerProtocolProtos.OMRequest omRequest = null;
            try {
                omRequest = TrashOzoneFileSystem.this.createOMRequest(OzoneManagerProtocolProtos.Type.DeleteKeys).setDeleteKeysRequest(deleteKeysRequest).build();
            }
            catch (IOException e) {
                LOG.error("Couldn't get userinfo", (Throwable)e);
            }
            return omRequest;
        }
    }

    private abstract class OzoneListingIterator {
        private final Path path;
        private final FileStatus status;
        private String pathKey;
        private Iterator<String> keyIterator;

        OzoneListingIterator(Path path) throws IOException {
            this.path = path;
            this.status = TrashOzoneFileSystem.this.getFileStatus(path);
            this.pathKey = OzoneFSUtils.pathToKey((Path)path);
            if (this.status.isDirectory()) {
                this.pathKey = OzoneFSUtils.addTrailingSlashIfNeeded((String)this.pathKey);
            }
            OFSPath fsPath = new OFSPath(this.pathKey, TrashOzoneFileSystem.this.ozoneConfiguration);
            this.keyIterator = this.getKeyIterator(fsPath.getVolumeName(), fsPath.getBucketName(), fsPath.getKeyName());
        }

        private Iterator<String> getKeyIterator(String volumeName, String bucketName, String keyName) throws IOException {
            ArrayList<String> keys = new ArrayList<String>(this.listKeys(volumeName, bucketName, "", keyName));
            String lastKey = (String)keys.get(keys.size() - 1);
            List<String> nextBatchKeys = this.listKeys(volumeName, bucketName, lastKey, keyName);
            while (!nextBatchKeys.isEmpty()) {
                keys.addAll(nextBatchKeys);
                lastKey = nextBatchKeys.get(nextBatchKeys.size() - 1);
                nextBatchKeys = this.listKeys(volumeName, bucketName, lastKey, keyName);
            }
            return keys.iterator();
        }

        abstract boolean processKeyPath(List<String> var1) throws IOException;

        boolean iterate() throws IOException {
            LOG.trace("Iterating path: {}", (Object)this.path);
            ArrayList<String> keyPathList = new ArrayList<String>();
            if (this.status.isDirectory()) {
                LOG.trace("Iterating directory: {}", (Object)this.pathKey);
                OFSPath ofsPath = new OFSPath(this.pathKey, TrashOzoneFileSystem.this.ozoneConfiguration);
                String ofsPathprefix = String.valueOf(ofsPath.getNonKeyPathNoPrefixDelim()) + "/";
                while (this.keyIterator.hasNext()) {
                    String keyName = this.keyIterator.next();
                    String keyPath = String.valueOf(ofsPathprefix) + keyName;
                    LOG.trace("iterating key path: {}", (Object)keyPath);
                    keyPathList.add(keyPath);
                    if (keyPathList.size() < 100) continue;
                    if (!this.processKeyPath(keyPathList)) {
                        return false;
                    }
                    keyPathList.clear();
                }
                return keyPathList.isEmpty() || this.processKeyPath(keyPathList);
            }
            LOG.trace("iterating file: {}", (Object)this.path);
            keyPathList.add(this.pathKey);
            return this.processKeyPath(keyPathList);
        }

        FileStatus getStatus() {
            return this.status;
        }

        List<String> listKeys(String volumeName, String bucketName, String startKey, String keyPrefix) throws IOException {
            OMMetadataManager metadataManager = TrashOzoneFileSystem.this.ozoneManager.getMetadataManager();
            return metadataManager.listKeys(volumeName, bucketName, startKey, keyPrefix, 10000).getKeys().stream().map(OmKeyInfo::getKeyName).collect(Collectors.toList());
        }
    }

    private class RenameIterator
    extends OzoneListingIterator {
        private final String srcPath;
        private final String dstPath;

        RenameIterator(Path srcPath, Path dstPath) throws IOException {
            super(srcPath);
            this.srcPath = OzoneFSUtils.pathToKey((Path)srcPath);
            this.dstPath = OzoneFSUtils.pathToKey((Path)dstPath);
            LOG.trace("rename from:{} to:{}", (Object)this.srcPath, (Object)this.dstPath);
        }

        @Override
        boolean processKeyPath(List<String> keyPathList) {
            for (String keyPath : keyPathList) {
                String newPath = this.dstPath.concat(keyPath.substring(this.srcPath.length()));
                OFSPath src = new OFSPath(keyPath, TrashOzoneFileSystem.this.ozoneConfiguration);
                OFSPath dst = new OFSPath(newPath, TrashOzoneFileSystem.this.ozoneConfiguration);
                OzoneManagerProtocolProtos.OMRequest omRequest = TrashOzoneFileSystem.this.getRenameKeyRequest(src, dst);
                try {
                    TrashOzoneFileSystem.this.ozoneManager.getMetrics().incNumTrashFilesRenames();
                    TrashOzoneFileSystem.this.submitRequest(omRequest);
                }
                catch (Throwable e) {
                    LOG.error("Couldn't send rename request.", e);
                }
            }
            return true;
        }
    }
}

