/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.audit;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.AuditMarker;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogger {
    private static final Logger LOG = LoggerFactory.getLogger(AuditLogger.class);
    private ExtendedLogger logger;
    private static final String FQCN = AuditLogger.class.getName();
    private static final Marker WRITE_MARKER = AuditMarker.WRITE.getMarker();
    private static final Marker READ_MARKER = AuditMarker.READ.getMarker();
    private static final Marker AUTH_MARKER = AuditMarker.AUTH.getMarker();
    private static final Marker PERFORMANCE = AuditMarker.PERFORMANCE.getMarker();
    private final AtomicReference<Set<String>> debugCmdSetRef = new AtomicReference(new HashSet());
    public static final String AUDIT_LOG_DEBUG_CMD_LIST_PREFIX = "ozone.audit.log.debug.cmd.list.";
    private AuditLoggerType type;
    private final Map<String, String> opNameCache = new ConcurrentHashMap<String, String>();

    public AuditLogger(AuditLoggerType type) {
        this.initializeLogger(type);
    }

    private void initializeLogger(AuditLoggerType loggerType) {
        this.logger = LogManager.getContext((boolean)false).getLogger(loggerType.getType());
        this.type = loggerType;
        this.refreshDebugCmdSet();
    }

    @VisibleForTesting
    public ExtendedLogger getLogger() {
        return this.logger;
    }

    public void logWriteSuccess(AuditMessage msg) {
        if (this.shouldLogAtDebug(msg)) {
            this.logger.logIfEnabled(FQCN, Level.DEBUG, WRITE_MARKER, (Message)msg, null);
        } else {
            this.logger.logIfEnabled(FQCN, Level.INFO, WRITE_MARKER, (Message)msg, null);
        }
    }

    public void logWriteFailure(AuditMessage msg) {
        this.logger.logIfEnabled(FQCN, Level.ERROR, WRITE_MARKER, (Message)msg, msg.getThrowable());
    }

    public void logAuthFailure(AuditMessage msg) {
        this.logger.logIfEnabled(FQCN, Level.ERROR, AUTH_MARKER, (Message)msg, msg.getThrowable());
    }

    public void logReadSuccess(AuditMessage msg) {
        if (this.shouldLogAtDebug(msg)) {
            this.logger.logIfEnabled(FQCN, Level.DEBUG, READ_MARKER, (Message)msg, null);
        } else {
            this.logger.logIfEnabled(FQCN, Level.INFO, READ_MARKER, (Message)msg, null);
        }
    }

    public void logReadFailure(AuditMessage msg) {
        this.logger.logIfEnabled(FQCN, Level.ERROR, READ_MARKER, (Message)msg, msg.getThrowable());
    }

    public void logWrite(AuditMessage auditMessage) {
        if (auditMessage.getThrowable() == null) {
            this.logWriteSuccess(auditMessage);
        } else {
            this.logWriteFailure(auditMessage);
        }
    }

    public void logPerformance(AuditMessage msg) {
        this.logger.logIfEnabled(FQCN, Level.INFO, PERFORMANCE, (Message)msg, null);
    }

    public void refreshDebugCmdSet() {
        OzoneConfiguration conf = new OzoneConfiguration();
        this.refreshDebugCmdSet(conf);
    }

    public void refreshDebugCmdSet(OzoneConfiguration conf) {
        Collection cmds = conf.getTrimmedStringCollection(AUDIT_LOG_DEBUG_CMD_LIST_PREFIX + this.type.getType().toLowerCase(Locale.ROOT));
        LOG.info("Refresh DebugCmdSet for {} to {}.", (Object)this.type.getType(), (Object)cmds);
        this.debugCmdSetRef.set(cmds.stream().map(String::toLowerCase).collect(Collectors.toSet()));
    }

    private boolean shouldLogAtDebug(AuditMessage auditMessage) {
        return this.debugCmdSetRef.get().contains(this.getLowerCaseOp(auditMessage.getOp()));
    }

    private String getLowerCaseOp(String op) {
        return this.opNameCache.computeIfAbsent(op, k -> k.toLowerCase(Locale.ROOT));
    }

    public static class PerformanceStringBuilder {
        private final StringBuilder builder = new StringBuilder(128).append('{');

        public void appendMetaLatencyNanos(long nanos) {
            this.append("metaLatencyMs", TimeUnit.NANOSECONDS.toMillis(nanos));
        }

        public void appendOpLatencyNanos(long nanos) {
            this.append("opLatencyMs", TimeUnit.NANOSECONDS.toMillis(nanos));
        }

        public void appendPreOpLatencyMs(long millis) {
            this.append("preOpLatencyMs", millis);
        }

        public void appendPreOpLatencyNano(long nanos) {
            this.append("preOpLatencyMs", TimeUnit.NANOSECONDS.toMillis(nanos));
        }

        public void appendOpLatencyMs(long millis) {
            this.append("opLatencyMs", millis);
        }

        public void appendSizeBytes(long bytes) {
            this.append("sizeByte", bytes);
        }

        public void appendCount(long count) {
            this.append("count", count);
        }

        public void appendStreamMode() {
            this.append("streamMode", "true");
        }

        private void append(String name, long value) {
            this.append(name, String.valueOf(value));
        }

        private void append(String name, String value) {
            this.builder.append(name).append('=').append(value).append(", ");
        }

        public String build() {
            int length = this.builder.length();
            if (length < 2) {
                return "{}";
            }
            this.builder.setCharAt(length - 2, '}');
            this.builder.setLength(length - 1);
            return this.builder.toString();
        }
    }
}

