/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.math.BigDecimal;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.utils.db.managed.ManagedBlockBasedTableConfig;
import org.apache.hadoop.hdds.utils.db.managed.ManagedBloomFilter;
import org.apache.hadoop.hdds.utils.db.managed.ManagedColumnFamilyOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedDBOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedLRUCache;
import org.rocksdb.Cache;
import org.rocksdb.CompactionStyle;
import org.rocksdb.Filter;
import org.rocksdb.TableFormatConfig;

public enum DBProfile {
    SSD{

        public String toString() {
            return "SSD";
        }

        @Override
        public ManagedColumnFamilyOptions getColumnFamilyOptions() {
            long writeBufferSize = 1.toLong(StorageUnit.MB.toBytes(128.0));
            ManagedColumnFamilyOptions managedColumnFamilyOptions = new ManagedColumnFamilyOptions();
            managedColumnFamilyOptions.setLevelCompactionDynamicLevelBytes(true).setWriteBufferSize(writeBufferSize).setTableFormatConfig((TableFormatConfig)this.getBlockBasedTableConfig());
            return managedColumnFamilyOptions;
        }

        @Override
        public ManagedDBOptions getDBOptions() {
            int maxBackgroundCompactions = 4;
            int maxBackgroundFlushes = 2;
            long bytesPerSync = 1.toLong(StorageUnit.MB.toBytes(1.0));
            boolean createIfMissing = true;
            boolean createMissingColumnFamilies = true;
            ManagedDBOptions dbOptions = new ManagedDBOptions();
            dbOptions.setIncreaseParallelism(Runtime.getRuntime().availableProcessors()).setMaxBackgroundCompactions(4).setMaxBackgroundFlushes(2).setBytesPerSync(bytesPerSync).setCreateIfMissing(true).setCreateMissingColumnFamilies(true);
            return dbOptions;
        }

        @Override
        public ManagedBlockBasedTableConfig getBlockBasedTableConfig() {
            long blockCacheSize = 1.toLong(StorageUnit.MB.toBytes(256.0));
            long blockSize = 1.toLong(StorageUnit.KB.toBytes(16.0));
            ManagedBlockBasedTableConfig config = new ManagedBlockBasedTableConfig();
            config.setBlockCache((Cache)new ManagedLRUCache(blockCacheSize)).setBlockSize(blockSize).setPinL0FilterAndIndexBlocksInCache(true).setFilterPolicy((Filter)new ManagedBloomFilter());
            return config;
        }
    }
    ,
    DISK{

        public String toString() {
            return "DISK";
        }

        @Override
        public ManagedDBOptions getDBOptions() {
            long readAheadSize = 2.toLong(StorageUnit.MB.toBytes(4.0));
            ManagedDBOptions dbOptions = SSD.getDBOptions();
            dbOptions.setCompactionReadaheadSize(readAheadSize);
            return dbOptions;
        }

        @Override
        public ManagedColumnFamilyOptions getColumnFamilyOptions() {
            ManagedColumnFamilyOptions cfOptions = SSD.getColumnFamilyOptions();
            cfOptions.setCompactionStyle(CompactionStyle.LEVEL);
            return cfOptions;
        }

        @Override
        public ManagedBlockBasedTableConfig getBlockBasedTableConfig() {
            return SSD.getBlockBasedTableConfig();
        }
    }
    ,
    TEST{

        public String toString() {
            return "TEST";
        }

        @Override
        public ManagedDBOptions getDBOptions() {
            ManagedDBOptions dbOptions = SSD.getDBOptions();
            return dbOptions;
        }

        @Override
        public ManagedColumnFamilyOptions getColumnFamilyOptions() {
            ManagedColumnFamilyOptions cfOptions = SSD.getColumnFamilyOptions();
            cfOptions.setCompactionStyle(CompactionStyle.LEVEL);
            cfOptions.setDisableAutoCompactions(true);
            return cfOptions;
        }

        @Override
        public ManagedBlockBasedTableConfig getBlockBasedTableConfig() {
            return SSD.getBlockBasedTableConfig();
        }
    };


    public static long toLong(double value) {
        BigDecimal temp = BigDecimal.valueOf(value);
        return temp.longValue();
    }

    public abstract ManagedDBOptions getDBOptions();

    public abstract ManagedColumnFamilyOptions getColumnFamilyOptions();

    public abstract ManagedBlockBasedTableConfig getBlockBasedTableConfig();
}

