/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import org.apache.hadoop.hdds.utils.db.cache.CacheStats;
import org.apache.hadoop.hdds.utils.db.cache.TableCache;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;

public final class TableCacheMetrics
implements MetricsSource {
    public static final String SOURCE_NAME = TableCacheMetrics.class.getSimpleName();
    private final TableCache<?, ?> cache;
    private final String tableName;

    private TableCacheMetrics(TableCache<?, ?> cache, String name) {
        this.cache = cache;
        this.tableName = name;
    }

    public static TableCacheMetrics create(TableCache<?, ?> cache, String tableName) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        TableCacheMetrics tableMetrics = new TableCacheMetrics(cache, tableName);
        return (TableCacheMetrics)ms.register(tableMetrics.getSourceName(), "Table cache metrics", (Object)tableMetrics);
    }

    private String getSourceName() {
        return this.tableName + "Cache";
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder recordBuilder = collector.addRecord(SOURCE_NAME).setContext("Table cache metrics").tag((MetricsInfo)MetricsInfos.TableName, this.tableName);
        CacheStats stats = this.cache.getStats();
        recordBuilder.addGauge((MetricsInfo)MetricsInfos.Size, this.cache.size()).addGauge((MetricsInfo)MetricsInfos.HitCount, stats.getCacheHits()).addGauge((MetricsInfo)MetricsInfos.MissCount, stats.getCacheMisses()).addGauge((MetricsInfo)MetricsInfos.IterationCount, stats.getIterationTimes());
    }

    public void unregister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(this.getSourceName());
    }

    private static enum MetricsInfos implements MetricsInfo
    {
        TableName("Table Name."),
        Size("Size of the cache."),
        HitCount("Number of time the lookup methods return a cached value."),
        MissCount("Number of times the requested value is not in the cache."),
        IterationCount("Number of times the table cache is iterated through.");

        private final String desc;

        private MetricsInfos(String desc) {
            this.desc = desc;
        }

        public String description() {
            return this.desc;
        }
    }
}

