/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.server.http.HttpServer2;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public final class LogLevel {
    private static final String USAGES = "\nUsage: Command options are:\n\t[-getlevel <host:port> <classname> [-protocol (http|https)]\n\t[-setlevel <host:port> <classname> <level> [-protocol (http|https)]\n";
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";
    private static final String SLF4J_LOG4J_ADAPTER_CLASS = "org.slf4j.reload4j.Reload4jLoggerAdapter";
    private static final String MARKER = "<!-- OUTPUT -->";
    private static final Pattern TAG = Pattern.compile("<[^>]*>");
    private static final AtomicBoolean IS_LOG4J_LOGGER = new AtomicBoolean(true);

    public static void main(String[] args) throws Exception {
        CLI cli = new CLI(new Configuration());
        System.exit(ToolRunner.run((Tool)cli, (String[])args));
    }

    private LogLevel() {
    }

    private static void printUsage() {
        System.err.println(USAGES);
        GenericOptionsParser.printGenericCommandUsage((PrintStream)System.err);
    }

    public static boolean isValidProtocol(String protocol) {
        return protocol.equals(PROTOCOL_HTTP) || protocol.equals(PROTOCOL_HTTPS);
    }

    private static boolean isLog4jLogger(String logger) {
        if (logger == null || !IS_LOG4J_LOGGER.get()) {
            return false;
        }
        Logger log = LoggerFactory.getLogger((String)logger);
        try {
            Class<?> log4jClass = Class.forName(SLF4J_LOG4J_ADAPTER_CLASS);
            return log4jClass.isInstance(log);
        }
        catch (ClassNotFoundException e) {
            IS_LOG4J_LOGGER.set(false);
            return false;
        }
    }

    @VisibleForTesting
    static class CLI
    extends Configured
    implements Tool {
        private Operations operation = Operations.UNKNOWN;
        private String protocol;
        private String hostName;
        private String className;
        private String level;

        CLI(Configuration conf) {
            this.setConf(conf);
        }

        public int run(String[] args) throws Exception {
            try {
                this.parseArguments(args);
                this.sendLogLevelRequest();
            }
            catch (IllegalArgumentException e) {
                LogLevel.printUsage();
                return -1;
            }
            return 0;
        }

        private void sendLogLevelRequest() throws IllegalArgumentException, Exception {
            switch (this.operation.ordinal()) {
                case 0: {
                    this.doGetLevel();
                    break;
                }
                case 1: {
                    this.doSetLevel();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Expect either -getlevel or -setlevel");
                }
            }
        }

        public void parseArguments(String[] args) throws IllegalArgumentException {
            if (args.length == 0) {
                throw new IllegalArgumentException("No arguments specified");
            }
            int nextArgIndex = 0;
            while (nextArgIndex < args.length) {
                if (args[nextArgIndex].equals("-getlevel")) {
                    nextArgIndex = this.parseGetLevelArgs(args, nextArgIndex);
                    continue;
                }
                if (args[nextArgIndex].equals("-setlevel")) {
                    nextArgIndex = this.parseSetLevelArgs(args, nextArgIndex);
                    continue;
                }
                if (args[nextArgIndex].equals("-protocol")) {
                    nextArgIndex = this.parseProtocolArgs(args, nextArgIndex);
                    continue;
                }
                throw new IllegalArgumentException("Unexpected argument " + args[nextArgIndex]);
            }
            if (this.operation == Operations.UNKNOWN) {
                throw new IllegalArgumentException("Must specify either -getlevel or -setlevel");
            }
            if (this.protocol == null) {
                this.protocol = LogLevel.PROTOCOL_HTTP;
            }
        }

        private int parseGetLevelArgs(String[] args, int index) throws IllegalArgumentException {
            if (this.operation != Operations.UNKNOWN) {
                throw new IllegalArgumentException("Redundant -getlevel command");
            }
            if (index + 2 >= args.length) {
                throw new IllegalArgumentException("-getlevel needs two parameters");
            }
            this.operation = Operations.GETLEVEL;
            this.hostName = args[index + 1];
            this.className = args[index + 2];
            return index + 3;
        }

        private int parseSetLevelArgs(String[] args, int index) throws IllegalArgumentException {
            if (this.operation != Operations.UNKNOWN) {
                throw new IllegalArgumentException("Redundant -setlevel command");
            }
            if (index + 3 >= args.length) {
                throw new IllegalArgumentException("-setlevel needs three parameters");
            }
            this.operation = Operations.SETLEVEL;
            this.hostName = args[index + 1];
            this.className = args[index + 2];
            this.level = args[index + 3];
            return index + 4;
        }

        private int parseProtocolArgs(String[] args, int index) throws IllegalArgumentException {
            if (this.protocol != null) {
                throw new IllegalArgumentException("Redundant -protocol command");
            }
            if (index + 1 >= args.length) {
                throw new IllegalArgumentException("-protocol needs one parameter");
            }
            this.protocol = args[index + 1];
            if (!LogLevel.isValidProtocol(this.protocol)) {
                throw new IllegalArgumentException("Invalid protocol: " + this.protocol);
            }
            return index + 2;
        }

        private void doGetLevel() throws Exception {
            this.process(this.protocol + "://" + this.hostName + "/logLevel?log=" + this.className);
        }

        private void doSetLevel() throws Exception {
            this.process(this.protocol + "://" + this.hostName + "/logLevel?log=" + this.className + "&level=" + this.level);
        }

        private URLConnection connect(URL url) throws Exception {
            HttpURLConnection connection;
            AuthenticatedURL.Token token = new AuthenticatedURL.Token();
            if (LogLevel.PROTOCOL_HTTPS.equals(url.getProtocol())) {
                SSLFactory clientSslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, this.getConf());
                clientSslFactory.init();
                SSLSocketFactory sslSocketF = clientSslFactory.createSSLSocketFactory();
                AuthenticatedURL aUrl = new AuthenticatedURL((Authenticator)new KerberosAuthenticator(), (ConnectionConfigurator)clientSslFactory);
                connection = aUrl.openConnection(url, token);
                HttpsURLConnection httpsConn = (HttpsURLConnection)connection;
                httpsConn.setSSLSocketFactory(sslSocketF);
            } else {
                AuthenticatedURL aUrl = new AuthenticatedURL((Authenticator)new KerberosAuthenticator());
                connection = aUrl.openConnection(url, token);
            }
            connection.connect();
            return connection;
        }

        private void process(String urlString) throws Exception {
            String line;
            URL url = new URL(urlString);
            System.out.println("Connecting to " + url);
            URLConnection connection = this.connect(url);
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            while ((line = in.readLine()) != null) {
                if (!line.startsWith(LogLevel.MARKER)) continue;
                System.out.println(TAG.matcher(line).replaceAll(""));
            }
            in.close();
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
    @InterfaceStability.Unstable
    public static class Servlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        private static final String FORMS = "\n<br /><hr /><h3>Get / Set</h3>\n<form>Class Name: <input type='text' size='50' name='log' /> <input type='submit' value='Get Log Level' /></form>\n<form>Class Name: <input type='text' size='50' name='log' /> Level: <input type='text' name='level' /> <input type='submit' value='Set Log Level' /></form>";

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (!HttpServer2.hasAdministratorAccess(this.getServletContext(), request, response)) {
                return;
            }
            PrintWriter out = ServletUtil.initHTML((ServletResponse)response, (String)"Log Level");
            String logName = ServletUtil.getParameter((ServletRequest)request, (String)"log");
            String level = ServletUtil.getParameter((ServletRequest)request, (String)"level");
            if (logName != null) {
                out.println("<br /><hr /><h3>Results</h3>");
                out.println("<!-- OUTPUT -->Submitted Class Name: <b>" + logName + "</b><br />");
                Logger log = LoggerFactory.getLogger((String)logName);
                out.println("<!-- OUTPUT -->Log Class: <b>" + log.getClass().getName() + "</b><br />");
                if (level != null) {
                    out.println("<!-- OUTPUT -->Submitted Level: <b>" + level + "</b><br />");
                }
                if (LogLevel.isLog4jLogger(logName)) {
                    Servlet.process(org.apache.log4j.Logger.getLogger((String)logName), level, out);
                } else {
                    out.println("Sorry, setting log level is only supported for log4j loggers.<br />");
                }
            }
            out.println(FORMS);
            out.println(ServletUtil.HTML_TAIL);
        }

        private static void process(org.apache.log4j.Logger log, String level, PrintWriter out) throws IOException {
            if (level != null) {
                if (!level.equalsIgnoreCase(Level.toLevel((String)level).toString())) {
                    out.println("<!-- OUTPUT -->Bad Level : <b>" + level + "</b><br />");
                } else {
                    log.setLevel(Level.toLevel((String)level));
                    out.println("<!-- OUTPUT -->Setting Level to " + level + " ...<br />");
                }
            }
            out.println("<!-- OUTPUT -->Effective Level: <b>" + log.getEffectiveLevel() + "</b><br />");
        }
    }

    private static enum Operations {
        GETLEVEL,
        SETLEVEL,
        UNKNOWN;

    }
}

