/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server.events;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.server.events.EventWatcherMetrics;
import org.apache.hadoop.hdds.server.events.IdentifiableEventPayload;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.ozone.lease.LeaseAlreadyExistException;
import org.apache.hadoop.ozone.lease.LeaseExpiredException;
import org.apache.hadoop.ozone.lease.LeaseManager;
import org.apache.hadoop.ozone.lease.LeaseNotFoundException;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventWatcher<TIMEOUT_PAYLOAD extends IdentifiableEventPayload, COMPLETION_PAYLOAD extends IdentifiableEventPayload> {
    private static final Logger LOG = LoggerFactory.getLogger(EventWatcher.class);
    private final Event<TIMEOUT_PAYLOAD> startEvent;
    private final Event<COMPLETION_PAYLOAD> completionEvent;
    private final LeaseManager<Long> leaseManager;
    private final EventWatcherMetrics metrics;
    private final String name;
    private final Map<Long, TIMEOUT_PAYLOAD> trackedEventsByID = new ConcurrentHashMap<Long, TIMEOUT_PAYLOAD>();
    private final Set<TIMEOUT_PAYLOAD> trackedEvents = new HashSet<TIMEOUT_PAYLOAD>();
    private final Map<Long, Long> startTrackingTimes = new HashMap<Long, Long>();

    public EventWatcher(String name, Event<TIMEOUT_PAYLOAD> startEvent, Event<COMPLETION_PAYLOAD> completionEvent, LeaseManager<Long> leaseManager) {
        this.startEvent = startEvent;
        this.completionEvent = completionEvent;
        this.leaseManager = leaseManager;
        this.metrics = new EventWatcherMetrics();
        Preconditions.checkNotNull((Object)name);
        if (name.equals("")) {
            name = this.getClass().getSimpleName();
        }
        if (name.equals("")) {
            name = this.getClass().getName();
        }
        this.name = name;
    }

    public EventWatcher(Event<TIMEOUT_PAYLOAD> startEvent, Event<COMPLETION_PAYLOAD> completionEvent, LeaseManager<Long> leaseManager) {
        this("", startEvent, completionEvent, leaseManager);
    }

    public void start(EventQueue queue) {
        queue.addHandler(this.startEvent, this::handleStartEvent);
        queue.addHandler(this.completionEvent, (completionPayload, publisher) -> {
            try {
                this.handleCompletion(completionPayload, publisher);
            }
            catch (LeaseNotFoundException e) {
                LOG.warn("Completion event without active lease. Id={}", (Object)completionPayload.getId());
            }
        });
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.register(this.name, "EventWatcher metrics", (Object)this.metrics);
    }

    private synchronized void handleStartEvent(TIMEOUT_PAYLOAD payload, EventPublisher publisher) {
        this.metrics.incrementTrackedEvents();
        long identifier = payload.getId();
        this.startTrackingTimes.put(identifier, Time.monotonicNow());
        this.trackedEventsByID.put(identifier, payload);
        this.trackedEvents.add(payload);
        try {
            this.leaseManager.acquire((Long)identifier, () -> this.handleTimeout(publisher, identifier));
        }
        catch (LeaseAlreadyExistException leaseAlreadyExistException) {
        }
        catch (LeaseExpiredException e) {
            this.handleTimeout(publisher, identifier);
        }
    }

    protected synchronized void handleCompletion(COMPLETION_PAYLOAD completionPayload, EventPublisher publisher) throws LeaseNotFoundException {
        long id = completionPayload.getId();
        this.leaseManager.release(id);
        IdentifiableEventPayload payload = (IdentifiableEventPayload)this.trackedEventsByID.remove(id);
        if (this.trackedEvents.remove(payload)) {
            this.metrics.incrementCompletedEvents();
            long originalTime = this.startTrackingTimes.remove(id);
            this.metrics.updateFinishingTime(Time.monotonicNow() - originalTime);
            this.onFinished(publisher, payload);
        }
    }

    private synchronized Void handleTimeout(EventPublisher publisher, long identifier) {
        this.metrics.incrementTimedOutEvents();
        IdentifiableEventPayload payload = (IdentifiableEventPayload)this.trackedEventsByID.remove(identifier);
        this.trackedEvents.remove(payload);
        this.startTrackingTimes.remove(payload.getId());
        this.onTimeout(publisher, payload);
        return null;
    }

    public synchronized boolean contains(TIMEOUT_PAYLOAD payload) {
        return this.trackedEvents.contains(payload);
    }

    public synchronized boolean remove(TIMEOUT_PAYLOAD payload) {
        try {
            this.leaseManager.release(payload.getId());
        }
        catch (LeaseNotFoundException e) {
            LOG.warn("Completion event without active lease. Id={}", (Object)payload.getId());
        }
        this.trackedEventsByID.remove(payload.getId());
        return this.trackedEvents.remove(payload);
    }

    protected abstract void onTimeout(EventPublisher var1, TIMEOUT_PAYLOAD var2);

    protected abstract void onFinished(EventPublisher var1, TIMEOUT_PAYLOAD var2);

    public List<TIMEOUT_PAYLOAD> getTimeoutEvents(Predicate<? super TIMEOUT_PAYLOAD> predicate) {
        return this.trackedEventsByID.values().stream().filter(predicate).collect(Collectors.toList());
    }

    @VisibleForTesting
    protected EventWatcherMetrics getMetrics() {
        return this.metrics;
    }
}

