/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.symmetric;

import com.google.protobuf.ByteString;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.SCMSecretKeyProtocolProtos;
import org.apache.hadoop.ozone.util.ProtobufUtils;
import org.apache.hadoop.security.token.TokenIdentifier;

public final class ManagedSecretKey {
    private final UUID id;
    private final Instant creationTime;
    private final Instant expiryTime;
    private final SecretKey secretKey;
    private final Map<Long, Mac> macInstances = new ConcurrentHashMap<Long, Mac>();

    public ManagedSecretKey(UUID id, Instant creationTime, Instant expiryTime, SecretKey secretKey) {
        this.id = id;
        this.creationTime = creationTime;
        this.expiryTime = expiryTime;
        this.secretKey = secretKey;
    }

    private Mac getMac() {
        long threadId = Thread.currentThread().getId();
        return this.macInstances.computeIfAbsent(threadId, k -> {
            try {
                return Mac.getInstance(this.secretKey.getAlgorithm());
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Invalid algorithm " + this.secretKey.getAlgorithm(), e);
            }
        });
    }

    public boolean isExpired() {
        return this.expiryTime.isBefore(Instant.now());
    }

    public UUID getId() {
        return this.id;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Instant getExpiryTime() {
        return this.expiryTime;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ManagedSecretKey)) {
            return false;
        }
        ManagedSecretKey that = (ManagedSecretKey)obj;
        return this.id.equals(that.id);
    }

    public String toString() {
        return "SecretKey(id = " + this.id + ", creation at: " + this.creationTime + ", expire at: " + this.expiryTime + ")";
    }

    public byte[] sign(byte[] data) {
        try {
            Mac mac = this.getMac();
            mac.init(this.secretKey);
            return mac.doFinal(data);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid key to HMAC computation", e);
        }
    }

    public byte[] sign(TokenIdentifier tokenId) {
        return this.sign(tokenId.getBytes());
    }

    public boolean isValidSignature(byte[] data, byte[] signature) {
        byte[] expectedSignature = this.sign(data);
        return MessageDigest.isEqual(expectedSignature, signature);
    }

    public boolean isValidSignature(TokenIdentifier tokenId, byte[] signature) {
        return this.isValidSignature(tokenId.getBytes(), signature);
    }

    public SCMSecretKeyProtocolProtos.ManagedSecretKey toProtobuf() {
        return SCMSecretKeyProtocolProtos.ManagedSecretKey.newBuilder().setId(ProtobufUtils.toProtobuf((UUID)this.id)).setCreationTime(this.creationTime.toEpochMilli()).setExpiryTime(this.expiryTime.toEpochMilli()).setAlgorithm(this.secretKey.getAlgorithm()).setEncoded(ByteString.copyFrom((byte[])this.secretKey.getEncoded())).build();
    }

    public static ManagedSecretKey fromProtobuf(SCMSecretKeyProtocolProtos.ManagedSecretKey message) {
        UUID id = ProtobufUtils.fromProtobuf((HddsProtos.UUID)message.getId());
        Instant creationTime = Instant.ofEpochMilli(message.getCreationTime());
        Instant expiryTime = Instant.ofEpochMilli(message.getExpiryTime());
        SecretKeySpec secretKey = new SecretKeySpec(message.getEncoded().toByteArray(), message.getAlgorithm());
        return new ManagedSecretKey(id, creationTime, expiryTime, secretKey);
    }
}

