/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.fs.DUOptimizedFactory;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface SpaceUsageCheckFactory {
    public static final String CONFIG_PREFIX = "hdds.datanode.du.factory";

    public SpaceUsageCheckParams paramsFor(File var1);

    default public SpaceUsageCheckParams paramsFor(File dir, Supplier<File> exclusionProvider) {
        return this.paramsFor(dir);
    }

    default public SpaceUsageCheckFactory setConfiguration(ConfigurationSource conf) {
        return this;
    }

    public static SpaceUsageCheckFactory create(ConfigurationSource config) {
        Conf conf = (Conf)config.getObject(Conf.class);
        Class<SpaceUsageCheckFactory> aClass = null;
        String className = conf.getClassName();
        if (className != null && !className.isEmpty()) {
            try {
                aClass = SpaceUsageCheckFactory.class.getClassLoader().loadClass(className).asSubclass(SpaceUsageCheckFactory.class);
            }
            catch (ClassNotFoundException | RuntimeException e) {
                Logger log = LoggerFactory.getLogger(SpaceUsageCheckFactory.class);
                log.warn("Error trying to create SpaceUsageCheckFactory: '{}'", (Object)className, (Object)e);
            }
        }
        SpaceUsageCheckFactory instance = null;
        if (aClass != null) {
            try {
                Constructor constructor = aClass.getConstructor(new Class[0]);
                instance = (SpaceUsageCheckFactory)constructor.newInstance(new Object[0]);
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                Logger log = LoggerFactory.getLogger(SpaceUsageCheckFactory.class);
                log.warn("Error trying to create {}", aClass, (Object)e);
            }
        }
        if (instance == null) {
            instance = SpaceUsageCheckFactory.defaultImplementation();
        }
        return instance.setConfiguration(config);
    }

    public static SpaceUsageCheckFactory defaultImplementation() {
        return new DUOptimizedFactory();
    }

    @ConfigGroup(prefix="hdds.datanode.du.factory")
    public static class Conf {
        private static final String CLASSNAME_KEY = "classname";
        @Config(key="classname", defaultValue="", tags={ConfigTag.DATANODE}, description="The fully qualified name of the factory class that creates objects for providing disk space usage information.  It should implement the SpaceUsageCheckFactory interface.")
        private String className;

        public void setClassName(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public static String configKeyForClassName() {
            return "hdds.datanode.du.factory.classname";
        }
    }
}

