/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.compaction.log;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.MessageLite;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CopyObject;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.ozone.compaction.log.CompactionFileInfo;

public final class CompactionLogEntry
implements CopyObject<CompactionLogEntry> {
    private static final Codec<CompactionLogEntry> CODEC = new DelegatedCodec(Proto2Codec.get((MessageLite)HddsProtos.CompactionLogEntryProto.getDefaultInstance()), CompactionLogEntry::getFromProtobuf, CompactionLogEntry::getProtobuf, CompactionLogEntry.class);
    private final long dbSequenceNumber;
    private final long compactionTime;
    private final List<CompactionFileInfo> inputFileInfoList;
    private final List<CompactionFileInfo> outputFileInfoList;
    private final String compactionReason;

    @VisibleForTesting
    public CompactionLogEntry(long dbSequenceNumber, long compactionTime, List<CompactionFileInfo> inputFileInfoList, List<CompactionFileInfo> outputFileInfoList, String compactionReason) {
        this.dbSequenceNumber = dbSequenceNumber;
        this.compactionTime = compactionTime;
        this.inputFileInfoList = inputFileInfoList;
        this.outputFileInfoList = outputFileInfoList;
        this.compactionReason = compactionReason;
    }

    public static Codec<CompactionLogEntry> getCodec() {
        return CODEC;
    }

    public List<CompactionFileInfo> getInputFileInfoList() {
        return this.inputFileInfoList;
    }

    public List<CompactionFileInfo> getOutputFileInfoList() {
        return this.outputFileInfoList;
    }

    public long getDbSequenceNumber() {
        return this.dbSequenceNumber;
    }

    public long getCompactionTime() {
        return this.compactionTime;
    }

    public String getCompactionReason() {
        return this.compactionReason;
    }

    public HddsProtos.CompactionLogEntryProto getProtobuf() {
        HddsProtos.CompactionLogEntryProto.Builder builder = HddsProtos.CompactionLogEntryProto.newBuilder().setDbSequenceNumber(this.dbSequenceNumber).setCompactionTime(this.compactionTime);
        if (this.compactionReason != null) {
            builder.setCompactionReason(this.compactionReason);
        }
        this.inputFileInfoList.forEach(fileInfo -> builder.addInputFileIntoList(fileInfo.getProtobuf()));
        this.outputFileInfoList.forEach(fileInfo -> builder.addOutputFileIntoList(fileInfo.getProtobuf()));
        return builder.build();
    }

    public static CompactionLogEntry getFromProtobuf(HddsProtos.CompactionLogEntryProto proto) {
        List<CompactionFileInfo> inputFileInfo = proto.getInputFileIntoListList().stream().map(CompactionFileInfo::getFromProtobuf).collect(Collectors.toList());
        List<CompactionFileInfo> outputFileInfo = proto.getOutputFileIntoListList().stream().map(CompactionFileInfo::getFromProtobuf).collect(Collectors.toList());
        Builder builder = new Builder(proto.getDbSequenceNumber(), proto.getCompactionTime(), inputFileInfo, outputFileInfo);
        if (proto.hasCompactionReason()) {
            builder.setCompactionReason(proto.getCompactionReason());
        }
        return builder.build();
    }

    public String toString() {
        return String.format("dbSequenceNumber: '%s', compactionTime: '%s', inputFileInfoList: '%s', outputFileInfoList: '%s', compactionReason: '%s'.", this.dbSequenceNumber, this.compactionTime, this.inputFileInfoList, this.outputFileInfoList, this.compactionReason);
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.getDbSequenceNumber(), this.getCompactionTime(), this.getInputFileInfoList(), this.getOutputFileInfoList());
        String reason = this.getCompactionReason();
        if (this.getCompactionReason() != null) {
            builder.setCompactionReason(reason);
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompactionLogEntry)) {
            return false;
        }
        CompactionLogEntry that = (CompactionLogEntry)o;
        return this.dbSequenceNumber == that.dbSequenceNumber && this.compactionTime == that.compactionTime && Objects.equals(this.inputFileInfoList, that.inputFileInfoList) && Objects.equals(this.outputFileInfoList, that.outputFileInfoList) && Objects.equals(this.compactionReason, that.compactionReason);
    }

    public int hashCode() {
        return Objects.hash(this.dbSequenceNumber, this.compactionTime, this.inputFileInfoList, this.outputFileInfoList, this.compactionReason);
    }

    public CompactionLogEntry copyObject() {
        return new CompactionLogEntry(this.dbSequenceNumber, this.compactionTime, this.inputFileInfoList, this.outputFileInfoList, this.compactionReason);
    }

    public static class Builder {
        private final long dbSequenceNumber;
        private final long compactionTime;
        private List<CompactionFileInfo> inputFileInfoList;
        private final List<CompactionFileInfo> outputFileInfoList;
        private String compactionReason;

        public Builder(long dbSequenceNumber, long compactionTime, List<CompactionFileInfo> inputFileInfoList, List<CompactionFileInfo> outputFileInfoList) {
            Preconditions.checkNotNull(inputFileInfoList, (Object)"inputFileInfoList is required parameter.");
            Preconditions.checkNotNull(outputFileInfoList, (Object)"outputFileInfoList is required parameter.");
            this.dbSequenceNumber = dbSequenceNumber;
            this.compactionTime = compactionTime;
            this.inputFileInfoList = inputFileInfoList;
            this.outputFileInfoList = outputFileInfoList;
        }

        public Builder setCompactionReason(String compactionReason) {
            this.compactionReason = compactionReason;
            return this;
        }

        public Builder updateInputFileInfoList(List<CompactionFileInfo> fileInfoList) {
            this.inputFileInfoList = fileInfoList;
            return this;
        }

        public CompactionLogEntry build() {
            return new CompactionLogEntry(this.dbSequenceNumber, this.compactionTime, this.inputFileInfoList, this.outputFileInfoList, this.compactionReason);
        }
    }
}

