/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.volume;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientException;
import org.apache.hadoop.ozone.shell.Handler;
import org.apache.hadoop.ozone.shell.ListPaginationOptions;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.PrefixFilterOption;
import org.apache.hadoop.security.UserGroupInformation;
import picocli.CommandLine;

@CommandLine.Command(name="list", aliases={"ls"}, description={"List the volumes of a given user"})
public class ListVolumeHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"Ozone URI could either be a full URI or short URI.\nFull URI should start with o3://, in case of non-HA\nclusters it should be followed by the host name and\noptionally the port number. In case of HA clusters\nthe service id should be used. Service id provides a\nlogical name for multiple hosts and it is defined\nin the property ozone.om.service.ids.\nExample of a full URI with host name and port number\nfor a key:\no3://omhostname:9862/vol1/bucket1/key1\nWith a service id for a volume:\no3://omserviceid/vol1/\nShort URI should start from the volume.\nExample of a short URI for a bucket:\nvol1/bucket1\nAny unspecified information will be identified from\nthe config files.\n"}, defaultValue="/")
    private String uri;
    @CommandLine.Mixin
    private ListPaginationOptions listOptions;
    @CommandLine.Mixin
    private PrefixFilterOption prefixFilter;
    @CommandLine.Option(names={"--user", "-u"}, description={"List accessible volumes of the user. This will be ignored if list all volumes option is specified."})
    private String userName;

    @Override
    protected OzoneAddress getAddress() throws OzoneClientException {
        OzoneAddress address = new OzoneAddress(this.uri);
        address.ensureRootAddress();
        return address;
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        if (this.userName == null) {
            this.userName = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        Iterator volumeIterator = this.userName != null && !this.listOptions.isAll() ? client.getObjectStore().listVolumesByUser(this.userName, this.prefixFilter.getPrefix(), this.listOptions.getStartItem()) : client.getObjectStore().listVolumes(this.prefixFilter.getPrefix(), this.listOptions.getStartItem());
        int counter = this.printAsJsonArray(volumeIterator, this.listOptions.getLimit());
        if (this.isVerbose()) {
            this.err().printf("Found : %d volumes for user : %s ", counter, this.userName);
        }
    }
}

