/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.bucket;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.bucket.BucketHandler;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"deletes a bucket"})
public class DeleteBucketHandler
extends BucketHandler {
    @CommandLine.Option(names={"-r"}, description={"Delete bucket recursively"})
    private boolean bRecursive;
    @CommandLine.Option(names={"-y", "--yes"}, description={"Continue without interactive user confirmation"})
    private boolean yes;
    private String omServiceId;
    private static final int MAX_KEY_DELETE_BATCH_SIZE = 1000;

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
        this.omServiceId = address.getOmServiceId((ConfigurationSource)this.getConf());
        if (this.bRecursive) {
            OzoneBucket bucket;
            if (!this.yes) {
                this.out().print("This command will delete bucket recursively.\nThere is no recovery option after using this command, and deleted keys won't move to trash.\nEnter 'yes' to proceed': ");
                this.out().flush();
                Scanner scanner = new Scanner(new InputStreamReader(System.in, StandardCharsets.UTF_8));
                String confirmation = scanner.next().trim().toLowerCase();
                if (!confirmation.equals("yes")) {
                    this.out().println("Operation cancelled.");
                    return;
                }
            }
            if ((bucket = vol.getBucket(bucketName)).getBucketLayout().equals((Object)BucketLayout.OBJECT_STORE)) {
                this.deleteOBSBucketRecursive(vol, bucket);
            } else {
                this.deleteFSBucketRecursive(vol, bucket);
            }
            return;
        }
        vol.deleteBucket(bucketName);
        this.out().printf("Bucket %s is deleted%n", bucketName);
    }

    private void deleteOBSBucketRecursive(OzoneVolume vol, OzoneBucket bucket) {
        ArrayList<String> keys = new ArrayList<String>();
        try {
            if (!bucket.isLink()) {
                Iterator iterator = bucket.listKeys(null);
                while (iterator.hasNext()) {
                    keys.add(((OzoneKey)iterator.next()).getName());
                    if (1000 != keys.size()) continue;
                    bucket.deleteKeys(keys);
                    keys.clear();
                }
                if (!keys.isEmpty()) {
                    bucket.deleteKeys(keys);
                }
            }
            vol.deleteBucket(bucket.getName());
            this.out().printf("Bucket %s is deleted%n", bucket.getName());
        }
        catch (Exception e) {
            this.out().printf("Could not delete bucket %s.%n", e.getMessage());
        }
    }

    private void deleteFSBucketRecursive(OzoneVolume vol, OzoneBucket bucket) {
        try {
            String hostPrefix = "ofs://" + this.omServiceId + "/";
            String ofsPrefix = hostPrefix + vol.getName() + "/" + bucket.getName();
            Path path = new Path(ofsPrefix);
            OzoneConfiguration clientConf = new OzoneConfiguration((Configuration)this.getConf());
            clientConf.set("fs.defaultFS", hostPrefix);
            FileSystem fs = FileSystem.get((Configuration)clientConf);
            if (!fs.delete(path, true)) {
                this.out().printf("Could not delete bucket %s.%n", bucket.getName());
                return;
            }
            this.out().printf("Bucket %s is deleted%n", bucket.getName());
        }
        catch (IOException e) {
            this.out().printf("Could not delete bucket %s.%n", e.getMessage());
        }
    }
}

