/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.metrics;

import java.io.Closeable;
import java.util.Map;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.ozone.util.PerformanceMetrics;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@Metrics(about="S3 Gateway Metrics", context="ozone")
public final class S3GatewayMetrics
implements Closeable,
MetricsSource {
    public static final String SOURCE_NAME = S3GatewayMetrics.class.getSimpleName();
    private MetricsRegistry registry = new MetricsRegistry(SOURCE_NAME);
    private static S3GatewayMetrics instance;
    @Metric
    private MutableCounterLong getBucketSuccess;
    @Metric
    private MutableCounterLong getBucketFailure;
    @Metric
    private MutableCounterLong createBucketSuccess;
    @Metric
    private MutableCounterLong createBucketFailure;
    @Metric
    private MutableCounterLong headBucketSuccess;
    @Metric
    private MutableCounterLong deleteBucketSuccess;
    @Metric
    private MutableCounterLong deleteBucketFailure;
    @Metric
    private MutableCounterLong getAclSuccess;
    @Metric
    private MutableCounterLong getAclFailure;
    @Metric
    private MutableCounterLong putAclSuccess;
    @Metric
    private MutableCounterLong putAclFailure;
    @Metric
    private MutableCounterLong listMultipartUploadsSuccess;
    @Metric
    private MutableCounterLong listMultipartUploadsFailure;
    @Metric
    private MutableCounterLong listKeyCount;
    @Metric
    private MutableCounterLong listS3BucketsSuccess;
    @Metric
    private MutableCounterLong listS3BucketsFailure;
    @Metric
    private MutableCounterLong createMultipartKeySuccess;
    @Metric
    private MutableCounterLong createMultipartKeyFailure;
    @Metric
    private MutableCounterLong copyObjectSuccess;
    @Metric
    private MutableCounterLong copyObjectFailure;
    @Metric
    private MutableCounterLong createKeySuccess;
    @Metric
    private MutableCounterLong createKeyFailure;
    @Metric
    private MutableCounterLong listPartsSuccess;
    @Metric
    private MutableCounterLong listPartsFailure;
    @Metric
    private MutableCounterLong getKeySuccess;
    @Metric
    private MutableCounterLong getKeyFailure;
    @Metric
    private MutableCounterLong headKeySuccess;
    @Metric
    private MutableCounterLong headKeyFailure;
    @Metric
    private MutableCounterLong initMultipartUploadSuccess;
    @Metric
    private MutableCounterLong initMultipartUploadFailure;
    @Metric
    private MutableCounterLong completeMultipartUploadSuccess;
    @Metric
    private MutableCounterLong completeMultipartUploadFailure;
    @Metric
    private MutableCounterLong abortMultipartUploadSuccess;
    @Metric
    private MutableCounterLong abortMultipartUploadFailure;
    @Metric
    private MutableCounterLong deleteKeySuccess;
    @Metric
    private MutableCounterLong deleteKeyFailure;
    @Metric
    private MutableCounterLong copyObjectSuccessLength;
    @Metric
    private MutableCounterLong putKeySuccessLength;
    @Metric
    private MutableCounterLong getKeySuccessLength;
    @Metric
    private MutableCounterLong getObjectTaggingSuccess;
    @Metric
    private MutableCounterLong getObjectTaggingFailure;
    @Metric
    private MutableCounterLong putObjectTaggingSuccess;
    @Metric
    private MutableCounterLong putObjectTaggingFailure;
    @Metric
    private MutableCounterLong deleteObjectTaggingSuccess;
    @Metric
    private MutableCounterLong deleteObjectTaggingFailure;
    @Metric
    private MutableCounterLong putObjectAclSuccess;
    @Metric
    private MutableCounterLong putObjectAclFailure;
    @Metric(about="Latency for successfully retrieving an S3 bucket in nanoseconds")
    private PerformanceMetrics getBucketSuccessLatencyNs;
    @Metric(about="Latency for failing to retrieve an S3 bucket in nanoseconds")
    private PerformanceMetrics getBucketFailureLatencyNs;
    @Metric(about="Latency for successfully creating an S3 bucket in nanoseconds")
    private PerformanceMetrics createBucketSuccessLatencyNs;
    @Metric(about="Latency for failing to create an S3 bucket in nanoseconds")
    private PerformanceMetrics createBucketFailureLatencyNs;
    @Metric(about="Latency for successfully checking the existence of an S3 bucket in nanoseconds")
    private PerformanceMetrics headBucketSuccessLatencyNs;
    @Metric(about="Latency for successfully deleting an S3 bucket in nanoseconds")
    private PerformanceMetrics deleteBucketSuccessLatencyNs;
    @Metric(about="Latency for failing to delete an S3 bucket in nanoseconds")
    private PerformanceMetrics deleteBucketFailureLatencyNs;
    @Metric(about="Latency for successfully retrieving an S3 bucket ACL in nanoseconds")
    private PerformanceMetrics getAclSuccessLatencyNs;
    @Metric(about="Latency for failing to retrieve an S3 bucket ACL in nanoseconds")
    private PerformanceMetrics getAclFailureLatencyNs;
    @Metric(about="Latency for successfully setting an S3 bucket ACL in nanoseconds")
    private PerformanceMetrics putAclSuccessLatencyNs;
    @Metric(about="Latency for failing to set an S3 bucket ACL in nanoseconds")
    private PerformanceMetrics putAclFailureLatencyNs;
    @Metric(about="Latency for successfully listing multipart uploads in nanoseconds")
    private PerformanceMetrics listMultipartUploadsSuccessLatencyNs;
    @Metric(about="Latency for failing to list multipart uploads in nanoseconds")
    private PerformanceMetrics listMultipartUploadsFailureLatencyNs;
    @Metric(about="Latency for successfully listing S3 buckets in nanoseconds")
    private PerformanceMetrics listS3BucketsSuccessLatencyNs;
    @Metric(about="Latency for failing to list S3 buckets in nanoseconds")
    private PerformanceMetrics listS3BucketsFailureLatencyNs;
    @Metric(about="Latency for successfully creating a multipart object key in nanoseconds")
    private PerformanceMetrics createMultipartKeySuccessLatencyNs;
    @Metric(about="Latency for failing to create a multipart object key in nanoseconds")
    private PerformanceMetrics createMultipartKeyFailureLatencyNs;
    @Metric(about="Latency for successfully copying an S3 object in nanoseconds")
    private PerformanceMetrics copyObjectSuccessLatencyNs;
    @Metric(about="Latency for failing to copy an S3 object in nanoseconds")
    private PerformanceMetrics copyObjectFailureLatencyNs;
    @Metric(about="Latency for successfully creating an S3 object key in nanoseconds")
    private PerformanceMetrics createKeySuccessLatencyNs;
    @Metric(about="Latency for failing to create an S3 object key in nanoseconds")
    private PerformanceMetrics createKeyFailureLatencyNs;
    @Metric(about="Latency for successfully listing parts of a multipart upload in nanoseconds")
    private PerformanceMetrics listPartsSuccessLatencyNs;
    @Metric(about="Latency for failing to list parts of a multipart upload in nanoseconds")
    private PerformanceMetrics listPartsFailureLatencyNs;
    @Metric(about="Latency for successfully retrieving an S3 object in nanoseconds")
    private PerformanceMetrics getKeySuccessLatencyNs;
    @Metric(about="Latency for failing to retrieve an S3 object in nanoseconds")
    private PerformanceMetrics getKeyFailureLatencyNs;
    @Metric(about="Latency for successfully retrieving metadata for an S3 object in nanoseconds")
    private PerformanceMetrics headKeySuccessLatencyNs;
    @Metric(about="Latency for failing to retrieve metadata for an S3 object in nanoseconds")
    private PerformanceMetrics headKeyFailureLatencyNs;
    @Metric(about="Latency for successfully initiating a multipart upload in nanoseconds")
    private PerformanceMetrics initMultipartUploadSuccessLatencyNs;
    @Metric(about="Latency for failing to initiate a multipart upload in nanoseconds")
    private PerformanceMetrics initMultipartUploadFailureLatencyNs;
    @Metric(about="Latency for successfully completing a multipart upload in nanoseconds")
    private PerformanceMetrics completeMultipartUploadSuccessLatencyNs;
    @Metric(about="Latency for failing to complete a multipart upload in nanoseconds")
    private PerformanceMetrics completeMultipartUploadFailureLatencyNs;
    @Metric(about="Latency for successfully aborting a multipart upload in nanoseconds")
    private PerformanceMetrics abortMultipartUploadSuccessLatencyNs;
    @Metric(about="Latency for failing to abort a multipart upload in nanoseconds")
    private PerformanceMetrics abortMultipartUploadFailureLatencyNs;
    @Metric(about="Latency for successfully deleting an S3 object in nanoseconds")
    private PerformanceMetrics deleteKeySuccessLatencyNs;
    @Metric(about="Latency for failing to delete an S3 object in nanoseconds")
    private PerformanceMetrics deleteKeyFailureLatencyNs;
    @Metric(about="Latency for put metadata of an key in nanoseconds")
    private PerformanceMetrics putKeyMetadataLatencyNs;
    @Metric(about="Latency for get metadata of an key in nanoseconds")
    private PerformanceMetrics getKeyMetadataLatencyNs;
    @Metric(about="Latency for copy metadata of an key in nanoseconds")
    private PerformanceMetrics copyKeyMetadataLatencyNs;
    @Metric(about="Latency for successful get object tagging of a key in nanoseconds")
    private PerformanceMetrics getObjectTaggingSuccessLatencyNs;
    @Metric(about="Latency for failing to get object tagging of a key in nanoseconds")
    private PerformanceMetrics getObjectTaggingFailureLatencyNs;
    @Metric(about="Latency for successful put object tagging of a key in nanoseconds")
    private PerformanceMetrics putObjectTaggingSuccessLatencyNs;
    @Metric(about="Latency for failing to put object tagging of a key in nanoseconds")
    private PerformanceMetrics putObjectTaggingFailureLatencyNs;
    @Metric(about="Latency for successful delete object tagging of a key in nanoseconds")
    private PerformanceMetrics deleteObjectTaggingSuccessLatencyNs;
    @Metric(about="Latency for failing to delete object tagging of a key in nanoseconds")
    private PerformanceMetrics deleteObjectTaggingFailureLatencyNs;
    @Metric(about="Latency for successfully setting an S3 object ACL in nanoseconds")
    private PerformanceMetrics putObjectAclSuccessLatencyNs;
    @Metric(about="Latency for failing to set an S3 object ACL in nanoseconds")
    private PerformanceMetrics putObjectAclFailureLatencyNs;
    private final Map<String, PerformanceMetrics> performanceMetrics;

    private S3GatewayMetrics(OzoneConfiguration conf) {
        int[] intervals = conf.getInts("ozone.s3g.metrics.percentiles.intervals.seconds");
        this.performanceMetrics = PerformanceMetrics.initializeMetrics((Object)this, (MetricsRegistry)this.registry, (String)"Ops", (String)"Time", (int[])intervals);
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.performanceMetrics.values());
    }

    public static synchronized S3GatewayMetrics create(OzoneConfiguration conf) {
        if (instance != null) {
            return instance;
        }
        MetricsSystem ms = DefaultMetricsSystem.instance();
        instance = (S3GatewayMetrics)ms.register(SOURCE_NAME, "S3 Gateway Metrics", (Object)new S3GatewayMetrics(conf));
        return instance;
    }

    public static void unRegister() {
        IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{instance});
        instance = null;
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder recordBuilder = collector.addRecord(SOURCE_NAME);
        this.getBucketSuccess.snapshot(recordBuilder, true);
        this.getBucketSuccessLatencyNs.snapshot(recordBuilder, true);
        this.getBucketFailure.snapshot(recordBuilder, true);
        this.getBucketFailureLatencyNs.snapshot(recordBuilder, true);
        this.createBucketSuccess.snapshot(recordBuilder, true);
        this.createBucketSuccessLatencyNs.snapshot(recordBuilder, true);
        this.createBucketFailure.snapshot(recordBuilder, true);
        this.createBucketFailureLatencyNs.snapshot(recordBuilder, true);
        this.headBucketSuccess.snapshot(recordBuilder, true);
        this.headBucketSuccessLatencyNs.snapshot(recordBuilder, true);
        this.deleteBucketSuccess.snapshot(recordBuilder, true);
        this.deleteBucketSuccessLatencyNs.snapshot(recordBuilder, true);
        this.deleteBucketFailure.snapshot(recordBuilder, true);
        this.deleteBucketFailureLatencyNs.snapshot(recordBuilder, true);
        this.getAclSuccess.snapshot(recordBuilder, true);
        this.getAclSuccessLatencyNs.snapshot(recordBuilder, true);
        this.getAclFailure.snapshot(recordBuilder, true);
        this.getAclFailureLatencyNs.snapshot(recordBuilder, true);
        this.putAclSuccess.snapshot(recordBuilder, true);
        this.putAclSuccessLatencyNs.snapshot(recordBuilder, true);
        this.putAclFailure.snapshot(recordBuilder, true);
        this.putAclFailureLatencyNs.snapshot(recordBuilder, true);
        this.listMultipartUploadsSuccess.snapshot(recordBuilder, true);
        this.listMultipartUploadsSuccessLatencyNs.snapshot(recordBuilder, true);
        this.listMultipartUploadsFailure.snapshot(recordBuilder, true);
        this.listMultipartUploadsFailureLatencyNs.snapshot(recordBuilder, true);
        this.listS3BucketsSuccess.snapshot(recordBuilder, true);
        this.listS3BucketsSuccessLatencyNs.snapshot(recordBuilder, true);
        this.listS3BucketsFailure.snapshot(recordBuilder, true);
        this.listS3BucketsFailureLatencyNs.snapshot(recordBuilder, true);
        this.createMultipartKeySuccess.snapshot(recordBuilder, true);
        this.createMultipartKeySuccessLatencyNs.snapshot(recordBuilder, true);
        this.createMultipartKeyFailure.snapshot(recordBuilder, true);
        this.createMultipartKeyFailureLatencyNs.snapshot(recordBuilder, true);
        this.copyObjectSuccess.snapshot(recordBuilder, true);
        this.copyObjectSuccessLatencyNs.snapshot(recordBuilder, true);
        this.copyObjectFailure.snapshot(recordBuilder, true);
        this.copyObjectFailureLatencyNs.snapshot(recordBuilder, true);
        this.createKeySuccess.snapshot(recordBuilder, true);
        this.createKeySuccessLatencyNs.snapshot(recordBuilder, true);
        this.createKeyFailure.snapshot(recordBuilder, true);
        this.createKeyFailureLatencyNs.snapshot(recordBuilder, true);
        this.listPartsSuccess.snapshot(recordBuilder, true);
        this.listPartsSuccessLatencyNs.snapshot(recordBuilder, true);
        this.listPartsFailure.snapshot(recordBuilder, true);
        this.listPartsFailureLatencyNs.snapshot(recordBuilder, true);
        this.getKeySuccess.snapshot(recordBuilder, true);
        this.getKeySuccessLatencyNs.snapshot(recordBuilder, true);
        this.getKeyFailure.snapshot(recordBuilder, true);
        this.getKeyFailureLatencyNs.snapshot(recordBuilder, true);
        this.headKeySuccess.snapshot(recordBuilder, true);
        this.headKeySuccessLatencyNs.snapshot(recordBuilder, true);
        this.headKeyFailure.snapshot(recordBuilder, true);
        this.headKeyFailureLatencyNs.snapshot(recordBuilder, true);
        this.initMultipartUploadSuccess.snapshot(recordBuilder, true);
        this.initMultipartUploadSuccessLatencyNs.snapshot(recordBuilder, true);
        this.initMultipartUploadFailure.snapshot(recordBuilder, true);
        this.initMultipartUploadFailureLatencyNs.snapshot(recordBuilder, true);
        this.completeMultipartUploadSuccess.snapshot(recordBuilder, true);
        this.completeMultipartUploadSuccessLatencyNs.snapshot(recordBuilder, true);
        this.completeMultipartUploadFailure.snapshot(recordBuilder, true);
        this.completeMultipartUploadFailureLatencyNs.snapshot(recordBuilder, true);
        this.abortMultipartUploadSuccess.snapshot(recordBuilder, true);
        this.abortMultipartUploadSuccessLatencyNs.snapshot(recordBuilder, true);
        this.abortMultipartUploadFailure.snapshot(recordBuilder, true);
        this.abortMultipartUploadFailureLatencyNs.snapshot(recordBuilder, true);
        this.deleteKeySuccess.snapshot(recordBuilder, true);
        this.deleteKeySuccessLatencyNs.snapshot(recordBuilder, true);
        this.deleteKeyFailure.snapshot(recordBuilder, true);
        this.deleteKeyFailureLatencyNs.snapshot(recordBuilder, true);
        this.putKeyMetadataLatencyNs.snapshot(recordBuilder, true);
        this.getKeyMetadataLatencyNs.snapshot(recordBuilder, true);
        this.copyKeyMetadataLatencyNs.snapshot(recordBuilder, true);
        this.copyObjectSuccessLength.snapshot(recordBuilder, true);
        this.putKeySuccessLength.snapshot(recordBuilder, true);
        this.getKeySuccessLength.snapshot(recordBuilder, true);
        this.listKeyCount.snapshot(recordBuilder, true);
        this.getObjectTaggingSuccess.snapshot(recordBuilder, true);
        this.getObjectTaggingSuccessLatencyNs.snapshot(recordBuilder, true);
        this.getObjectTaggingFailure.snapshot(recordBuilder, true);
        this.getObjectTaggingFailureLatencyNs.snapshot(recordBuilder, true);
        this.putObjectTaggingSuccess.snapshot(recordBuilder, true);
        this.putObjectTaggingSuccessLatencyNs.snapshot(recordBuilder, true);
        this.putObjectTaggingFailure.snapshot(recordBuilder, true);
        this.putObjectTaggingFailureLatencyNs.snapshot(recordBuilder, true);
        this.deleteObjectTaggingSuccess.snapshot(recordBuilder, true);
        this.deleteObjectTaggingSuccessLatencyNs.snapshot(recordBuilder, true);
        this.deleteObjectTaggingFailure.snapshot(recordBuilder, true);
        this.deleteObjectTaggingFailureLatencyNs.snapshot(recordBuilder, true);
        this.putObjectAclSuccess.snapshot(recordBuilder, true);
        this.putObjectAclFailure.snapshot(recordBuilder, true);
    }

    public long updateGetBucketSuccessStats(long startNanos) {
        this.getBucketSuccess.incr();
        return this.updateAndGetStats(this.getBucketSuccessLatencyNs, startNanos);
    }

    public void updateGetBucketFailureStats(long startNanos) {
        this.getBucketFailure.incr();
        this.getBucketFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateCreateBucketSuccessStats(long startNanos) {
        this.createBucketSuccess.incr();
        this.createBucketSuccessLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateCreateBucketFailureStats(long startNanos) {
        this.createBucketFailure.incr();
        this.createBucketFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateHeadBucketSuccessStats(long startNanos) {
        this.headBucketSuccess.incr();
        this.headBucketSuccessLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateDeleteBucketSuccessStats(long startNanos) {
        this.deleteBucketSuccess.incr();
        this.deleteBucketSuccessLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateDeleteBucketFailureStats(long startNanos) {
        this.deleteBucketFailure.incr();
        this.deleteBucketFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateGetAclSuccessStats(long startNanos) {
        this.getAclSuccess.incr();
        this.getAclSuccessLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateGetAclFailureStats(long startNanos) {
        this.getAclFailure.incr();
        this.getAclFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updatePutAclSuccessStats(long startNanos) {
        this.putAclSuccess.incr();
        this.putAclSuccessLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updatePutAclFailureStats(long startNanos) {
        this.putAclFailure.incr();
        this.putAclFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void incListKeyCount(int count) {
        this.listKeyCount.incr((long)count);
    }

    public void updateListMultipartUploadsSuccessStats(long startNanos) {
        this.listMultipartUploadsSuccess.incr();
        this.listMultipartUploadsSuccessLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateListMultipartUploadsFailureStats(long startNanos) {
        this.listMultipartUploadsFailure.incr();
        this.listMultipartUploadsFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateListS3BucketsSuccessStats(long startNanos) {
        this.listS3BucketsSuccess.incr();
        this.listS3BucketsSuccessLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateListS3BucketsFailureStats(long startNanos) {
        this.listS3BucketsFailure.incr();
        this.listS3BucketsFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public long updateCreateMultipartKeySuccessStats(long startNanos) {
        this.createMultipartKeySuccess.incr();
        return this.updateAndGetStats(this.createMultipartKeySuccessLatencyNs, startNanos);
    }

    public void updateCreateMultipartKeyFailureStats(long startNanos) {
        this.createMultipartKeyFailure.incr();
        this.createMultipartKeyFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public long updateCopyObjectSuccessStats(long startNanos) {
        this.copyObjectSuccess.incr();
        return this.updateAndGetStats(this.copyObjectSuccessLatencyNs, startNanos);
    }

    public void updateCopyObjectFailureStats(long startNanos) {
        this.copyObjectFailure.incr();
        this.copyObjectFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public long updateCreateKeySuccessStats(long startNanos) {
        this.createKeySuccess.incr();
        return this.updateAndGetStats(this.createKeySuccessLatencyNs, startNanos);
    }

    public void updateCreateKeyFailureStats(long startNanos) {
        this.createKeyFailure.incr();
        this.createKeyFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public long updateListPartsSuccessStats(long startNanos) {
        this.listPartsSuccess.incr();
        return this.updateAndGetStats(this.listPartsSuccessLatencyNs, startNanos);
    }

    public void updateListPartsFailureStats(long startNanos) {
        this.listPartsFailure.incr();
        this.listPartsFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public long updateGetKeySuccessStats(long startNanos) {
        this.getKeySuccess.incr();
        return this.updateAndGetStats(this.getKeySuccessLatencyNs, startNanos);
    }

    public void updateGetKeyFailureStats(long startNanos) {
        this.getKeyFailure.incr();
        this.getKeyFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateHeadKeySuccessStats(long startNanos) {
        this.headKeySuccess.incr();
        this.headKeySuccessLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateHeadKeyFailureStats(long startNanos) {
        this.headKeyFailure.incr();
        this.headKeyFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateInitMultipartUploadSuccessStats(long startNanos) {
        this.initMultipartUploadSuccess.incr();
        this.initMultipartUploadSuccessLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateInitMultipartUploadFailureStats(long startNanos) {
        this.initMultipartUploadFailure.incr();
        this.initMultipartUploadFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateCompleteMultipartUploadSuccessStats(long startNanos) {
        this.completeMultipartUploadSuccess.incr();
        this.completeMultipartUploadSuccessLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateCompleteMultipartUploadFailureStats(long startNanos) {
        this.completeMultipartUploadFailure.incr();
        this.completeMultipartUploadFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateAbortMultipartUploadSuccessStats(long startNanos) {
        this.abortMultipartUploadSuccess.incr();
        this.abortMultipartUploadSuccessLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateAbortMultipartUploadFailureStats(long startNanos) {
        this.abortMultipartUploadFailure.incr();
        this.abortMultipartUploadFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateDeleteKeySuccessStats(long startNanos) {
        this.deleteKeySuccess.incr();
        this.deleteKeySuccessLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateDeleteKeyFailureStats(long startNanos) {
        this.deleteKeyFailure.incr();
        this.deleteKeyFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public long updateGetKeyMetadataStats(long startNanos) {
        return this.updateAndGetStats(this.getKeyMetadataLatencyNs, startNanos);
    }

    public long updateCopyKeyMetadataStats(long startNanos) {
        return this.updateAndGetStats(this.copyKeyMetadataLatencyNs, startNanos);
    }

    public long updatePutKeyMetadataStats(long startNanos) {
        return this.updateAndGetStats(this.putKeyMetadataLatencyNs, startNanos);
    }

    public void incCopyObjectSuccessLength(long bytes) {
        this.copyObjectSuccessLength.incr(bytes);
    }

    public void incPutKeySuccessLength(long bytes) {
        this.putKeySuccessLength.incr(bytes);
    }

    public void incGetKeySuccessLength(long bytes) {
        this.getKeySuccessLength.incr(bytes);
    }

    public void updateGetObjectTaggingSuccessStats(long startNanos) {
        this.getObjectTaggingSuccess.incr();
        this.getObjectTaggingSuccessLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateGetObjectTaggingFailureStats(long startNanos) {
        this.getObjectTaggingFailure.incr();
        this.getObjectTaggingFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updatePutObjectTaggingSuccessStats(long startNanos) {
        this.putObjectTaggingSuccess.incr();
        this.putObjectTaggingSuccessLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updatePutObjectTaggingFailureStats(long startNanos) {
        this.putObjectTaggingFailure.incr();
        this.putObjectTaggingFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateDeleteObjectTaggingSuccessStats(long startNanos) {
        this.deleteObjectTaggingSuccess.incr();
        this.deleteObjectTaggingSuccessLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updateDeleteObjectTaggingFailureStats(long startNanos) {
        this.deleteObjectTaggingFailure.incr();
        this.deleteObjectTaggingFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updatePutObjectAclSuccessStats(long startNanos) {
        this.putObjectAclSuccess.incr();
        this.putObjectAclSuccessLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public void updatePutObjectAclFailureStats(long startNanos) {
        this.putObjectAclFailure.incr();
        this.putObjectAclFailureLatencyNs.add(Time.monotonicNowNanos() - startNanos);
    }

    public long getListS3BucketsSuccess() {
        return this.listS3BucketsSuccess.value();
    }

    public long getHeadBucketSuccess() {
        return this.headBucketSuccess.value();
    }

    public long getHeadKeySuccess() {
        return this.headKeySuccess.value();
    }

    public long getGetBucketSuccess() {
        return this.getBucketSuccess.value();
    }

    public long getGetBucketFailure() {
        return this.getBucketFailure.value();
    }

    public long getCreateBucketSuccess() {
        return this.createBucketSuccess.value();
    }

    public long getCreateBucketFailure() {
        return this.createBucketFailure.value();
    }

    public long getDeleteBucketSuccess() {
        return this.deleteBucketSuccess.value();
    }

    public long getDeleteBucketFailure() {
        return this.deleteBucketFailure.value();
    }

    public long getGetAclSuccess() {
        return this.getAclSuccess.value();
    }

    public long getGetAclFailure() {
        return this.getAclFailure.value();
    }

    public long getPutAclSuccess() {
        return this.putAclSuccess.value();
    }

    public long getPutAclFailure() {
        return this.putAclFailure.value();
    }

    public long getListMultipartUploadsSuccess() {
        return this.listMultipartUploadsSuccess.value();
    }

    public long getListMultipartUploadsFailure() {
        return this.listMultipartUploadsFailure.value();
    }

    public long getCreateMultipartKeySuccess() {
        return this.createMultipartKeySuccess.value();
    }

    public long getCreateMultipartKeyFailure() {
        return this.createMultipartKeyFailure.value();
    }

    public long getCompleteMultiPartUploadSuccess() {
        return this.completeMultipartUploadSuccess.value();
    }

    public long getCompleteMultiPartUploadFailure() {
        return this.completeMultipartUploadFailure.value();
    }

    public long getListPartsSuccess() {
        return this.listPartsSuccess.value();
    }

    public long getListPartsFailure() {
        return this.listPartsFailure.value();
    }

    public long getCopyObjectSuccess() {
        return this.copyObjectSuccess.value();
    }

    public long getCopyObjectFailure() {
        return this.copyObjectFailure.value();
    }

    public long getCreateKeyFailure() {
        return this.createKeyFailure.value();
    }

    public long getCreateKeySuccess() {
        return this.createKeySuccess.value();
    }

    public long getInitMultiPartUploadSuccess() {
        return this.initMultipartUploadSuccess.value();
    }

    public long getInitMultiPartUploadFailure() {
        return this.initMultipartUploadFailure.value();
    }

    public long getDeleteKeySuccess() {
        return this.deleteKeySuccess.value();
    }

    public long getDeleteKeyFailure() {
        return this.deleteKeyFailure.value();
    }

    public long getGetKeyFailure() {
        return this.getKeyFailure.value();
    }

    public long getGetKeySuccess() {
        return this.getKeySuccess.value();
    }

    public long getAbortMultiPartUploadSuccess() {
        return this.abortMultipartUploadSuccess.value();
    }

    public long getAbortMultiPartUploadFailure() {
        return this.abortMultipartUploadFailure.value();
    }

    public long getHeadKeyFailure() {
        return this.headKeyFailure.value();
    }

    public long getListS3BucketsFailure() {
        return this.listS3BucketsFailure.value();
    }

    public long getGetObjectTaggingSuccess() {
        return this.getObjectTaggingSuccess.value();
    }

    public long getGetObjectTaggingFailure() {
        return this.getObjectTaggingFailure.value();
    }

    public long getPutObjectTaggingSuccess() {
        return this.putObjectTaggingSuccess.value();
    }

    public long getPutObjectTaggingFailure() {
        return this.putObjectTaggingFailure.value();
    }

    public long getDeleteObjectTaggingSuccess() {
        return this.deleteObjectTaggingSuccess.value();
    }

    public long getDeleteObjectTaggingFailure() {
        return this.deleteObjectTaggingFailure.value();
    }

    private long updateAndGetStats(PerformanceMetrics metric, long startNanos) {
        long value = Time.monotonicNowNanos() - startNanos;
        metric.add(value);
        return value;
    }

    public static synchronized S3GatewayMetrics getMetrics() {
        return instance;
    }
}

