/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.DtFetcher;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class O3fsDtFetcher
implements DtFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(O3fsDtFetcher.class);
    private static final String SERVICE_NAME = "o3fs";
    private static final String FETCH_FAILED = "Fetch ozone delegation token failed";

    public Text getServiceName() {
        return new Text(SERVICE_NAME);
    }

    public boolean isTokenRequired() {
        return UserGroupInformation.isSecurityEnabled();
    }

    public Token<?> addDelegationTokens(Configuration conf, Credentials creds, String renewer, String url) throws Exception {
        if (!url.startsWith(this.getServiceName().toString())) {
            url = this.getServiceName().toString() + "://" + url;
        }
        LOG.debug("addDelegationTokens from {} renewer {}.", (Object)url, (Object)renewer);
        FileSystem fs = FileSystem.get((URI)URI.create(url), (Configuration)conf);
        Token token = fs.getDelegationToken(renewer);
        if (token == null) {
            LOG.error(FETCH_FAILED);
            throw new IOException(FETCH_FAILED);
        }
        creds.addToken(token.getService(), token);
        return token;
    }
}

