/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.view;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.view.mxICellEditor;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Writer;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLWriter;
import javax.swing.text.html.MinimalHTMLWriter;

public class mxCellEditor
implements mxICellEditor {
    private static final String CANCEL_EDITING = "cancel-editing";
    private static final String INSERT_BREAK = "insert-break";
    private static final String SUBMIT_TEXT = "submit-text";
    public static int DEFAULT_MIN_WIDTH = 100;
    public static int DEFAULT_MIN_HEIGHT = 60;
    public static double DEFAULT_MINIMUM_EDITOR_SCALE = 1.0;
    protected mxGraphComponent graphComponent;
    protected double minimumEditorScale = DEFAULT_MINIMUM_EDITOR_SCALE;
    protected int minimumWidth = DEFAULT_MIN_WIDTH;
    protected int minimumHeight = DEFAULT_MIN_HEIGHT;
    protected transient Object editingCell;
    protected transient EventObject trigger;
    protected transient JScrollPane scrollPane;
    protected transient JTextArea textArea;
    protected transient JEditorPane editorPane;
    protected boolean extractHtmlBody = true;
    protected boolean replaceLinefeeds = true;
    protected boolean shiftEnterSubmitsText = false;
    transient Object editorEnterActionMapKey;
    transient Object textEnterActionMapKey;
    transient KeyStroke escapeKeystroke = KeyStroke.getKeyStroke("ESCAPE");
    transient KeyStroke enterKeystroke = KeyStroke.getKeyStroke("ENTER");
    transient KeyStroke shiftEnterKeystroke = KeyStroke.getKeyStroke("shift ENTER");
    protected AbstractAction cancelEditingAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            mxCellEditor.this.stopEditing(true);
        }
    };
    protected AbstractAction textSubmitAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            mxCellEditor.this.stopEditing(false);
        }
    };

    public mxCellEditor(mxGraphComponent graphComponent) {
        this.graphComponent = graphComponent;
        this.textArea = new JTextArea();
        this.textArea.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.textArea.setOpaque(false);
        this.editorPane = new JEditorPane();
        this.editorPane.setOpaque(false);
        this.editorPane.setBackground(new Color(0, 0, 0, 0));
        this.editorPane.setContentType("text/html");
        this.editorPane.setEditorKit(new NoLinefeedHtmlEditorKit());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.getViewport().setOpaque(false);
        this.scrollPane.setVisible(false);
        this.scrollPane.setOpaque(false);
        this.editorPane.getActionMap().put(CANCEL_EDITING, this.cancelEditingAction);
        this.textArea.getActionMap().put(CANCEL_EDITING, this.cancelEditingAction);
        this.editorPane.getActionMap().put(SUBMIT_TEXT, this.textSubmitAction);
        this.textArea.getActionMap().put(SUBMIT_TEXT, this.textSubmitAction);
        this.editorEnterActionMapKey = this.editorPane.getInputMap().get(this.enterKeystroke);
        this.textEnterActionMapKey = this.editorPane.getInputMap().get(this.enterKeystroke);
    }

    public boolean isExtractHtmlBody() {
        return this.extractHtmlBody;
    }

    public void setExtractHtmlBody(boolean value) {
        this.extractHtmlBody = value;
    }

    public boolean isReplaceHtmlLinefeeds() {
        return this.replaceLinefeeds;
    }

    public void setReplaceHtmlLinefeeds(boolean value) {
        this.replaceLinefeeds = value;
    }

    public boolean isShiftEnterSubmitsText() {
        return this.shiftEnterSubmitsText;
    }

    public void setShiftEnterSubmitsText(boolean value) {
        this.shiftEnterSubmitsText = value;
    }

    protected void configureActionMaps() {
        InputMap editorInputMap = this.editorPane.getInputMap();
        InputMap textInputMap = this.textArea.getInputMap();
        editorInputMap.put(this.escapeKeystroke, this.cancelEditingAction);
        textInputMap.put(this.escapeKeystroke, this.cancelEditingAction);
        if (this.graphComponent.isEnterStopsCellEditing()) {
            editorInputMap.put(this.shiftEnterKeystroke, this.editorEnterActionMapKey);
            textInputMap.put(this.shiftEnterKeystroke, this.textEnterActionMapKey);
            editorInputMap.put(this.enterKeystroke, SUBMIT_TEXT);
            textInputMap.put(this.enterKeystroke, SUBMIT_TEXT);
        } else {
            editorInputMap.put(this.enterKeystroke, this.editorEnterActionMapKey);
            textInputMap.put(this.enterKeystroke, this.textEnterActionMapKey);
            if (this.isShiftEnterSubmitsText()) {
                editorInputMap.put(this.shiftEnterKeystroke, SUBMIT_TEXT);
                textInputMap.put(this.shiftEnterKeystroke, SUBMIT_TEXT);
            } else {
                editorInputMap.remove(this.shiftEnterKeystroke);
                textInputMap.remove(this.shiftEnterKeystroke);
            }
        }
    }

    public Component getEditor() {
        if (this.textArea.getParent() != null) {
            return this.textArea;
        }
        if (this.editingCell != null) {
            return this.editorPane;
        }
        return null;
    }

    protected boolean useLabelBounds(mxCellState state) {
        mxIGraphModel model = state.getView().getGraph().getModel();
        mxGeometry geometry = model.getGeometry(state.getCell());
        return geometry != null && geometry.getOffset() != null && !geometry.isRelative() && (geometry.getOffset().getX() != 0.0 || geometry.getOffset().getY() != 0.0) || model.isEdge(state.getCell());
    }

    public Rectangle getEditorBounds(mxCellState state, double scale) {
        mxIGraphModel model = state.getView().getGraph().getModel();
        Rectangle bounds = null;
        if (this.useLabelBounds(state)) {
            bounds = state.getLabelBounds().getRectangle();
            bounds.height += 10;
        } else {
            bounds = state.getRectangle();
        }
        if (model.isVertex(state.getCell())) {
            String horizontal = mxUtils.getString(state.getStyle(), mxConstants.STYLE_LABEL_POSITION, "center");
            if (horizontal.equals("left")) {
                bounds.x = (int)((double)bounds.x - state.getWidth());
            } else if (horizontal.equals("right")) {
                bounds.x = (int)((double)bounds.x + state.getWidth());
            }
            String vertical = mxUtils.getString(state.getStyle(), mxConstants.STYLE_VERTICAL_LABEL_POSITION, "middle");
            if (vertical.equals("top")) {
                bounds.y = (int)((double)bounds.y - state.getHeight());
            } else if (vertical.equals("bottom")) {
                bounds.y = (int)((double)bounds.y + state.getHeight());
            }
        }
        bounds.setSize((int)Math.max(bounds.getWidth(), (double)Math.round((double)this.minimumWidth * scale)), (int)Math.max(bounds.getHeight(), (double)Math.round((double)this.minimumHeight * scale)));
        return bounds;
    }

    public void startEditing(Object cell, EventObject evt) {
        mxCellState state;
        if (this.editingCell != null) {
            this.stopEditing(true);
        }
        if ((state = this.graphComponent.getGraph().getView().getState(cell)) != null) {
            this.editingCell = cell;
            this.trigger = evt;
            double scale = Math.max(this.minimumEditorScale, this.graphComponent.getGraph().getView().getScale());
            this.scrollPane.setBounds(this.getEditorBounds(state, scale));
            this.scrollPane.setVisible(true);
            String value = this.getInitialValue(state, evt);
            JTextComponent currentEditor = null;
            if (this.graphComponent.getGraph().isHtmlLabel(cell)) {
                if (this.isExtractHtmlBody()) {
                    value = mxUtils.getBodyMarkup(value, this.isReplaceHtmlLinefeeds());
                }
                this.editorPane.setDocument(mxUtils.createHtmlDocumentObject(state.getStyle(), scale));
                this.editorPane.setText(value);
                JPanel wrapper = new JPanel(new BorderLayout());
                wrapper.setOpaque(false);
                wrapper.add((Component)this.editorPane, "Center");
                this.scrollPane.setViewportView(wrapper);
                currentEditor = this.editorPane;
            } else {
                this.textArea.setFont(mxUtils.getFont(state.getStyle(), scale));
                Color fontColor = mxUtils.getColor(state.getStyle(), mxConstants.STYLE_FONTCOLOR, Color.black);
                this.textArea.setForeground(fontColor);
                this.textArea.setText(value);
                this.scrollPane.setViewportView(this.textArea);
                currentEditor = this.textArea;
            }
            this.graphComponent.getGraphControl().add((Component)this.scrollPane, 0);
            if (this.isHideLabel(state)) {
                this.graphComponent.redraw(state);
            }
            currentEditor.revalidate();
            currentEditor.requestFocusInWindow();
            currentEditor.selectAll();
            this.configureActionMaps();
        }
    }

    protected boolean isHideLabel(mxCellState state) {
        return true;
    }

    public void stopEditing(boolean cancel) {
        if (this.editingCell != null) {
            this.scrollPane.transferFocusUpCycle();
            Object cell = this.editingCell;
            this.editingCell = null;
            if (!cancel) {
                EventObject trig = this.trigger;
                this.trigger = null;
                this.graphComponent.labelChanged(cell, this.getCurrentValue(), trig);
            } else {
                mxCellState state = this.graphComponent.getGraph().getView().getState(cell);
                this.graphComponent.redraw(state);
            }
            if (this.scrollPane.getParent() != null) {
                this.scrollPane.setVisible(false);
                this.scrollPane.getParent().remove(this.scrollPane);
            }
            this.graphComponent.requestFocusInWindow();
        }
    }

    protected String getInitialValue(mxCellState state, EventObject trigger) {
        return this.graphComponent.getEditingValue(state.getCell(), trigger);
    }

    public String getCurrentValue() {
        String result;
        if (this.textArea.getParent() != null) {
            result = this.textArea.getText();
        } else {
            result = this.editorPane.getText();
            if (this.isExtractHtmlBody()) {
                result = mxUtils.getBodyMarkup(result, this.isReplaceHtmlLinefeeds());
            }
        }
        return result;
    }

    public Object getEditingCell() {
        return this.editingCell;
    }

    public double getMinimumEditorScale() {
        return this.minimumEditorScale;
    }

    public void setMinimumEditorScale(double minimumEditorScale) {
        this.minimumEditorScale = minimumEditorScale;
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setMinimumWidth(int minimumWidth) {
        this.minimumWidth = minimumWidth;
    }

    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    public void setMinimumHeight(int minimumHeight) {
        this.minimumHeight = minimumHeight;
    }

    class NoLinefeedHtmlWriter
    extends HTMLWriter {
        public NoLinefeedHtmlWriter(Writer buf, HTMLDocument doc, int pos, int len) {
            super(buf, doc, pos, len);
        }

        protected void setLineLength(int l) {
            super.setLineLength(l);
        }
    }

    class NoLinefeedHtmlEditorKit
    extends HTMLEditorKit {
        NoLinefeedHtmlEditorKit() {
        }

        public void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
            if (doc instanceof HTMLDocument) {
                NoLinefeedHtmlWriter w = new NoLinefeedHtmlWriter(out, (HTMLDocument)doc, pos, len);
                w.setLineLength(Integer.MAX_VALUE);
                w.write();
            } else if (doc instanceof StyledDocument) {
                MinimalHTMLWriter w = new MinimalHTMLWriter(out, (StyledDocument)doc, pos, len);
                w.write();
            } else {
                super.write(out, doc, pos, len);
            }
        }
    }
}

