/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.erasurecode.rawcoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.util.PerformanceAdvisory;
import org.apache.ozone.erasurecode.rawcoder.ByteArrayDecodingState;
import org.apache.ozone.erasurecode.rawcoder.ByteBufferDecodingState;
import org.apache.ozone.erasurecode.rawcoder.RawErasureDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
abstract class AbstractNativeRawDecoder
extends RawErasureDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNativeRawDecoder.class);
    protected final ReentrantReadWriteLock decoderLock = new ReentrantReadWriteLock();

    AbstractNativeRawDecoder(ECReplicationConfig replicationConfig) {
        super(replicationConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDecode(ByteBufferDecodingState decodingState) throws IOException {
        this.decoderLock.readLock().lock();
        try {
            ByteBuffer buffer;
            int i;
            int[] inputOffsets = new int[decodingState.inputs.length];
            int[] outputOffsets = new int[decodingState.outputs.length];
            for (i = 0; i < decodingState.inputs.length; ++i) {
                buffer = decodingState.inputs[i];
                if (buffer == null) continue;
                inputOffsets[i] = buffer.position();
            }
            for (i = 0; i < decodingState.outputs.length; ++i) {
                buffer = decodingState.outputs[i];
                outputOffsets[i] = buffer.position();
            }
            this.performDecodeImpl(decodingState.inputs, inputOffsets, decodingState.decodeLength, decodingState.erasedIndexes, decodingState.outputs, outputOffsets);
        }
        finally {
            this.decoderLock.readLock().unlock();
        }
    }

    protected abstract void performDecodeImpl(ByteBuffer[] var1, int[] var2, int var3, int[] var4, ByteBuffer[] var5, int[] var6) throws IOException;

    @Override
    protected void doDecode(ByteArrayDecodingState decodingState) throws IOException {
        PerformanceAdvisory.LOG.debug("convertToByteBufferState is invoked, not efficiently. Please use direct ByteBuffer inputs/outputs");
        ByteBufferDecodingState bbdState = decodingState.convertToByteBufferState();
        this.doDecode(bbdState);
        for (int i = 0; i < decodingState.outputs.length; ++i) {
            bbdState.outputs[i].get(decodingState.outputs[i], decodingState.outputOffsets[i], decodingState.decodeLength);
        }
    }

    @Override
    public boolean preferDirectBuffer() {
        return true;
    }
}

